
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables
hours_Bill = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_Bill")
hours_Mary = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_Mary")
hours_Peggy = m.addVar(vtype=GRB.INTEGER, name="hours_worked_by_Peggy")

# Objective function
m.setObjective(8.53 * hours_Bill + 1.19 * hours_Mary + 3.23 * hours_Peggy, GRB.MINIMIZE)

# Constraints
m.addConstr(3 * hours_Mary + 8 * hours_Peggy >= 30, name="Mary_and_Peggy_at_least_30")
m.addConstr(11 * hours_Bill + 8 * hours_Peggy >= 30, name="Bill_and_Peggy_at_least_30")
m.addConstr(11 * hours_Bill + 3 * hours_Mary + 8 * hours_Peggy >= 30, name="All_at_least_30")
m.addConstr(6 * hours_Mary - 2 * hours_Peggy >= 0, name="Mary_and_Peggy_relation")
m.addConstr(11 * hours_Bill + 3 * hours_Mary + 8 * hours_Peggy <= 122, name="Total_at_most_122")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hours worked by Bill: {hours_Bill.x}")
    print(f"Hours worked by Mary: {hours_Mary.x}")
    print(f"Hours worked by Peggy: {hours_Peggy.x}")
else:
    print("No optimal solution found")
