
import gurobipy as gp

# Define the model
m = gp.Model("optimization_problem")

# Define variables
hours_worked_by_Bill = m.addVar(name="hours_worked_by_Bill", lb=0, ub=144, vtype=gp.GRB.CONTINUOUS)
hours_worked_by_Mary = m.addVar(name="hours_worked_by_Mary", lb=0, ub=144, vtype=gp.GRB.CONTINUOUS)
hours_worked_by_Peggy = m.addVar(name="hours_worked_by_Peggy", lb=0, ub=144, vtype=gp.GRB.INTEGER)

# Objective function
m.setObjective(8.53 * hours_worked_by_Bill + 1.19 * hours_worked_by_Mary + 3.23 * hours_worked_by_Peggy, gp.GRB.MINIMIZE)

# Constraints
m.addConstr(3 * hours_worked_by_Mary + 8 * hours_worked_by_Peggy >= 30, name="combined_Mary_Peggy")
m.addConstr(11 * hours_worked_by_Bill + 8 * hours_worked_by_Peggy >= 30, name="combined_Bill_Peggy")
m.addConstr(11 * hours_worked_by_Bill + 3 * hours_worked_by_Mary + 8 * hours_worked_by_Peggy >= 30, name="combined_all")
m.addConstr(6 * hours_worked_by_Mary - 2 * hours_worked_by_Peggy >= 0, name="linear_constraint")
m.addConstr(11 * hours_worked_by_Bill + 3 * hours_worked_by_Mary + 8 * hours_worked_by_Peggy <= 122, name="total_likelihood")

# Solve the model
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Hours worked by Bill: {hours_worked_by_Bill.varValue}")
    print(f"Hours worked by Mary: {hours_worked_by_Mary.varValue}")
    print(f"Hours worked by Peggy: {hours_worked_by_Peggy.varValue}")
    print(f"Objective: {m.objVal}")
else:
    print("No optimal solution found.")
