
from gurobipy import Model, GRB

# Create a new model
model = Model("nutrition_optimization")

# Create variables
protein = model.addVar(lb=0, name="protein")  # grams of protein
vitamin_k = model.addVar(lb=0, name="vitamin_k")  # milligrams of vitamin K
carbs = model.addVar(lb=0, name="carbs")  # grams of carbohydrates

# Set objective function
model.setObjective(4 * protein + 8 * vitamin_k + 9 * carbs, GRB.MAXIMIZE)

# Add constraints
model.addConstr(11.41 * protein + 8.05 * carbs >= 51, "c1")
model.addConstr(2.81 * vitamin_k + 8.05 * carbs <= 369, "c2")
model.addConstr(11.41 * protein + 2.81 * vitamin_k + 8.05 * carbs <= 369, "c3")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    print('Protein: %g' % protein.x)
    print('Vitamin K: %g' % vitamin_k.x)
    print('Carbs: %g' % carbs.x)
elif model.status == GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % model.status)

