
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables - all are continuous
grams_of_protein = m.addVar(lb=-GRB.INFINITY, ub=GRB.INFINITY, vtype=GRB.CONTINUOUS, name="grams_of_protein")
milligrams_of_vitamin_K = m.addVar(lb=-GRB.INFINITY, ub=GRB.INFINITY, vtype=GRB.CONTINUOUS, name="milligrams_of_vitamin_K")
grams_of_carbohydrates = m.addVar(lb=-GRB.INFINITY, ub=GRB.INFINITY, vtype=GRB.CONTINUOUS, name="grams_of_carbohydrates")

# Objective function: Maximize 4*grams_of_protein + 8*milligrams_of_vitamin_K + 9*grams_of_carbohydrates
m.setObjective(4*grams_of_protein + 8*milligrams_of_vitamin_K + 9*grams_of_carbohydrates, GRB.MAXIMIZE)

# Constraints
# 1. Total kidney support index from grams of protein and grams of carbohydrates >= 51
m.addConstr(11.41*grams_of_protein + 8.05*grams_of_carbohydrates >= 51, name="constraint_1")

# 2. Total kidney support index from milligrams of vitamin K and grams of carbohydrates <= 369
m.addConstr(2.81*milligrams_of_vitamin_K + 8.05*grams_of_carbohydrates <= 369, name="constraint_2")

# 3. Total combined kidney support index from all three <= 369
m.addConstr(11.41*grams_of_protein + 2.81*milligrams_of_vitamin_K + 8.05*grams_of_carbohydrates <= 369, name="constraint_3")

# Solve the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Grams of Protein: {grams_of_protein.x}")
    print(f"Milligrams of Vitamin K: {milligrams_of_vitamin_K.x}")
    print(f"Grams of Carbohydrates: {grams_of_carbohydrates.x}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("No optimal solution found")
