
import gurobi

def optimize_kidney_support_index():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    protein = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="protein")
    vitamin_K = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="vitamin_K")
    carbohydrates = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="carbohydrates")

    # Objective function: Maximize 4*protein + 8*vitamin_K + 9*carbohydrates
    model.setObjective(4 * protein + 8 * vitamin_K + 9 * carbohydrates, gurobi.GRB.MAXIMIZE)

    # Constraints
    # Kidney support index for each component
    protein_kidney_index = 11.41
    vitamin_K_kidney_index = 2.81
    carbohydrates_kidney_index = 8.05

    # Constraint 1: protein + carbohydrates >= 51 / kidney support index scaling not applied as per problem description
    model.addConstraint(protein_kidney_index * protein + carbohydrates_kidney_index * carbohydrates >= 51, name="protein_carbohydrates_constraint")

    # Constraint 2: vitamin_K + carbohydrates <= 369
    model.addConstraint(vitamin_K_kidney_index * vitamin_K + carbohydrates_kidney_index * carbohydrates <= 369, name="vitamin_K_carbohydrates_constraint")

    # Constraint 3: protein + vitamin_K + carbohydrates <= 369
    model.addConstraint(protein_kidney_index * protein + vitamin_K_kidney_index * vitamin_K + carbohydrates_kidney_index * carbohydrates <= 369, name="all_components_constraint")

    # Solve the model
    model.optimize()

    # Print the results
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Protein: {protein.varValue}")
        print(f"Vitamin K: {vitamin_K.varValue}")
        print(f"Carbohydrates: {carbohydrates.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

optimize_kidney_support_index()
