
from gurobipy import Model, GRB

# Create a new model
model = Model("Work Optimization")

# Create variables
bill_hours = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Bill_Hours")
george_hours = model.addVar(lb=0, vtype=GRB.INTEGER, name="George_Hours")
laura_hours = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Laura_Hours")

# Set objective function
model.setObjective(7.46 * bill_hours + 6.91 * george_hours + 1.7 * laura_hours, GRB.MAXIMIZE)

# Add constraints
model.addConstr(3 * george_hours + 3 * laura_hours >= 17, "c1")
model.addConstr(-4 * george_hours + 10 * laura_hours >= 0, "c2")
model.addConstr(3 * bill_hours + 8 * george_hours <= 36, "c3")
model.addConstr(8 * george_hours + 2 * laura_hours <= 59, "c4")
model.addConstr(3 * bill_hours + 2 * laura_hours <= 73, "c5")
model.addConstr(3 * bill_hours + 8 * george_hours + 2 * laura_hours <= 73, "c6")
model.addConstr(3 * george_hours + 3 * laura_hours <= 20, "c7")
model.addConstr(4 * bill_hours + 3 * laura_hours <= 41, "c8")
model.addConstr(4 * bill_hours + 3 * george_hours + 3 * laura_hours <= 41, "c9")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal objective value: {model.objVal}")
    print(f"Bill's hours: {bill_hours.x}")
    print(f"George's hours: {george_hours.x}")
    print(f"Laura's hours: {laura_hours.x}")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status: {model.status}")

