
import gurobi

def optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define variables
    bill_hours = model.addVar(name="bill_hours", lb=0)  # Non-integer, no upper bound
    george_hours = model.addVar(name="george_hours", lb=0, type=gurobi.GRB.INTEGER)  # Integer required
    laura_hours = model.addVar(name="laura_hours", lb=0)  # Non-integer, no upper bound

    # Objective function
    model.setObjective(7.46 * bill_hours + 6.91 * george_hours + 1.7 * laura_hours, gurobi.GRB.MAXIMIZE)

    # Constraints
    # 1. Total combined productivity rating from George and Laura >= 17
    model.addConstr(3 * george_hours + 3 * laura_hours >= 17)

    # 2. -4 * hours worked by George + 10 * hours worked by Laura >= 0
    model.addConstr(-4 * george_hours + 10 * laura_hours >= 0)

    # 3. Total combined paperwork competence rating from Bill and George <= 36
    model.addConstr(3 * bill_hours + 8 * george_hours <= 36)

    # 4. Total combined paperwork competence rating from George and Laura <= 59
    model.addConstr(8 * george_hours + 2 * laura_hours <= 59)

    # 5. Total combined paperwork competence rating from Bill and Laura <= 73
    model.addConstr(3 * bill_hours + 2 * laura_hours <= 73)

    # 6. Total combined paperwork competence rating from Bill, George, and Laura <= 73
    model.addConstr(3 * bill_hours + 8 * george_hours + 2 * laura_hours <= 73)

    # 7. Total combined productivity rating from George and Laura <= 20
    model.addConstr(3 * george_hours + 3 * laura_hours <= 20)

    # 8. Total combined productivity rating from Bill and Laura <= 41
    model.addConstr(4 * bill_hours + 3 * laura_hours <= 41)

    # 9. Total combined productivity rating from Bill, George, and Laura <= 41
    model.addConstr(4 * bill_hours + 3 * george_hours + 3 * laura_hours <= 41)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Hours worked by Bill: {bill_hours.varValue}")
        print(f"Hours worked by George: {george_hours.varValue}")
        print(f"Hours worked by Laura: {laura_hours.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

optimization_problem()
