
from gurobipy import Model, GRB

# Create a new model
m = Model("optimization_problem")

# Create variables
fruit_salads = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="fruit_salads")
potatoes = m.addVar(lb=0, vtype=GRB.INTEGER, name="potatoes")

# Set objective function
m.setObjective(8.83 * fruit_salads**2 + 6.48 * fruit_salads * potatoes + 3.67 * fruit_salads + 6.4 * potatoes, GRB.MAXIMIZE)

# Add constraints
m.addConstr(12 * fruit_salads + 8 * potatoes >= 25, "fat_min")
m.addConstr(8 * fruit_salads**2 + 15 * potatoes**2 >= 52, "iron_min_squared")
m.addConstr(fruit_salads**2 - 10 * potatoes**2 >= 0, "fruit_potatoes_relation")
m.addConstr(12 * fruit_salads**2 + 8 * potatoes**2 <= 63, "fat_max_squared")
m.addConstr(12 * fruit_salads + 8 * potatoes <= 63, "fat_max")
m.addConstr(8 * fruit_salads + 15 * potatoes <= 141, "iron_max")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('fruit_salads:', fruit_salads.x)
    print('potatoes:', potatoes.x)
elif m.status == GRB.INFEASIBLE:
    print('Optimization problem is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

