
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables
fruit_salads = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.CONTINUOUS, name="fruit_salads")
potatoes = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.INTEGER, name="potatoes")

# Objective function
m.setObjective(8.83 * fruit_salads**2 + 6.48 * fruit_salads * potatoes + 3.67 * fruit_salads + 6.4 * potatoes, GRB.MAXIMIZE)

# Constraints
m.addConstr(12*fruit_salads + 8*potatoes >= 25, name="min_fat")
m.addConstr((fruit_salads**2)*8 + (potatoes**2)*15 >= 52, name="min_iron_squared")
m.addConstr(fruit_salads**2 - 10*potatoes**2 >= 0, name="quadratic_non_negativity")
m.addConstr((fruit_salads**2)*12 + (potatoes**2)*8 <= 63, name="max_fat_squared")
m.addConstr(12*fruit_salads + 8*potatoes <= 63, name="max_fat")
m.addConstr(8*fruit_salads + 15*potatoes <= 141, name="max_iron")

# Solve the model
m.optimize()

print("Objective Function Value:", m.objVal)
for v in m.getVars():
    print(f"{v.varName}: {v.x}")
