
import gurobi

def optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define variables
    fruit_salads = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="fruit_salads")
    potatoes = model.addVar(lb=0, ub=gurobi.GRB.INFINITY, type=gurobi.GRB.INTEGER, name="potatoes")

    # Objective function
    model.setObjective(8.83 * fruit_salads**2 + 6.48 * fruit_salads * potatoes + 3.67 * fruit_salads + 6.4 * potatoes, gurobi.GRB.MAXIMIZE)

    # Constraints
    # Fat content constraints
    model.addConstr(12 * fruit_salads + 8 * potatoes >= 25, name="min_fat")
    model.addConstr(12 * fruit_salads + 8 * potatoes <= 75, name="max_fat")

    # Iron content constraints
    model.addConstr(8 * fruit_salads + 15 * potatoes <= 141, name="max_iron")
    model.addConstr(8**2 * fruit_salads**2 + 15**2 * potatoes**2 >= 52, name="min_iron")

    # Fat and Iron Limits
    model.addConstr(fruit_salads**2 + potatoes**2 <= 63, name="fat_source_limit")
    model.addConstr(12 * fruit_salads + 8 * potatoes <= 63, name="fat_limit")

    # Other Constraints
    model.addConstr(fruit_salads**2 - 10 * potatoes**2 >= 0, name="non_linear_constraint")

    # Update model
    model.update()

    # Solve model
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Fruit Salads: ", fruit_salads.varValue)
        print("Potatoes: ", potatoes.varValue)
    else:
        print("Model is infeasible")

optimization_problem()
