
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("nutrition_optimization")

# Create variables
potassium = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="potassium")
fat = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="fat")
fiber = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="fiber")
calcium = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="calcium")

# Set objective function
m.setObjective(5*potassium + 2*fat + 4*fiber + 5*calcium, GRB.MAXIMIZE)

# Resource constraints
resources = {
    'r0': {'upper_bound': 597, 'x0': 24, 'x1': 25, 'x2': 10, 'x3': 25},
    'r1': {'upper_bound': 529, 'x0': 17, 'x1': 24, 'x2': 19, 'x3': 26},
    'r2': {'upper_bound': 533, 'x0': 13, 'x1': 15, 'x2': 28, 'x3': 23},
    'r3': {'upper_bound': 571, 'x0': 16, 'x1': 27, 'x2': 27, 'x3': 29}
}

for r, data in resources.items():
    m.addConstr(data['x0']*potassium + data['x1']*fat + data['x2']*fiber + data['x3']*calcium <= data['upper_bound'], name=r)


# Additional constraints
m.addConstr(25*fat + 25*calcium >= 116, "c1")
m.addConstr(25*fat + 10*fiber >= 90, "c2")
m.addConstr(24*potassium + 25*calcium >= 97, "c3")
m.addConstr(10*fiber + 25*calcium >= 97, "c4")
m.addConstr(24*potassium + 10*fiber + 25*calcium >= 109, "c5")
m.addConstr(24*potassium + 25*fat + 10*fiber >= 109, "c6")
m.addConstr(24*potassium + 10*fiber + 25*calcium >= 106, "c7")
m.addConstr(24*potassium + 25*fat + 10*fiber >= 106, "c8")
m.addConstr(19*fiber + 26*calcium >= 117, "c9")
m.addConstr(17*potassium + 26*calcium >= 104, "c10")
m.addConstr(24*fat + 19*fiber >= 90, "c11")
m.addConstr(17*potassium + 24*fat >= 113, "c12")
m.addConstr(24*fat + 26*calcium >= 71, "c13")
m.addConstr(17*potassium + 24*fat + 26*calcium >= 96, "c14")
m.addConstr(24*fat + 19*fiber + 26*calcium >= 96, "c15")
m.addConstr(17*potassium + 24*fat + 19*fiber >= 96, "c16")
m.addConstr(17*potassium + 24*fat + 26*calcium >= 80, "c17")
m.addConstr(24*fat + 19*fiber + 26*calcium >= 80, "c18")
m.addConstr(17*potassium + 24*fat + 19*fiber >= 80, "c19")
m.addConstr(17*potassium + 24*fat + 26*calcium >= 77, "c20")
m.addConstr(24*fat + 19*fiber + 26*calcium >= 77, "c21")
m.addConstr(17*potassium + 24*fat + 19*fiber >= 77, "c22")
m.addConstr(15*fat + 28*fiber >= 70, "c23")
m.addConstr(-2*potassium + 9*fat + 6*fiber >= 0, "c24")
m.addConstr(24*potassium + 25*calcium <= 537, "c25")
m.addConstr(25*fat + 25*calcium <= 379, "c26")
m.addConstr(10*fiber + 25*calcium <= 255, "c27")
m.addConstr(24*potassium + 25*fat + 10*fiber + 25*calcium <= 255, "c28")
m.addConstr(19*fiber + 26*calcium <= 462, "c29")
m.addConstr(24*fat + 19*fiber <= 403, "c30")
m.addConstr(24*fat + 26*calcium <= 474, "c31")
m.addConstr(17*potassium + 26*calcium <= 290, "c32")
m.addConstr(17*potassium + 24*fat <= 195, "c33")
m.addConstr(17*potassium + 24*fat + 19*fiber <= 499, "c34")
m.addConstr(17*potassium + 19*fiber + 26*calcium <= 405, "c35")
m.addConstr(17*potassium + 24*fat + 26*calcium <= 256, "c36")
m.addConstr(17*potassium + 24*fat + 19*fiber + 26*calcium <= 256, "c37")
m.addConstr(13*potassium + 28*fiber <= 151, "c38")
m.addConstr(15*fat + 23*calcium <= 154, "c39")
m.addConstr(13*potassium + 23*calcium <= 159, "c40")
m.addConstr(15*fat + 28*fiber <= 201, "c41")
m.addConstr(13*potassium + 15*fat + 28*fiber <= 413, "c42")
m.addConstr(13*potassium + 15*fat + 23*calcium <= 266, "c43")
m.addConstr(13*potassium + 15*fat + 28*fiber + 23*calcium <= 266, "c44")
m.addConstr(16*potassium + 27*fat <= 437, "c45")
m.addConstr(16*potassium + 27*fiber <= 256, "c46")
m.addConstr(16*potassium + 29*calcium <= 304, "c47")
m.addConstr(27*fat + 27*fiber <= 313, "c48")
m.addConstr(27*fiber + 29*calcium <= 400, "c49")
m.addConstr(16*potassium + 27*fat + 27*fiber <= 265, "c50")
m.addConstr(16*potassium + 27*fat + 29*calcium <= 207, "c51")
m.addConstr(16*potassium + 27*fat + 27*fiber + 29*calcium <= 207, "c52")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

