
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
milligrams_of_potassium = m.addVar(name="milligrams_of_potassium", lb=0)
grams_of_fat = m.addVar(name="grams_of_fat", lb=0)
grams_of_fiber = m.addVar(name="grams_of_fiber", lb=0)
milligrams_of_calcium = m.addVar(name="milligrams_of_calcium", lb=0)

# Objective function
m.setObjective(5 * milligrams_of_potassium + 2 * grams_of_fat + 4 * grams_of_fiber + 5 * milligrams_of_calcium, gp.GRB.MAXIMIZE)

# Constraints
# Immune support index constraints
m.addConstraint(24 * milligrams_of_potassium <= 597)
m.addConstraint(25 * grams_of_fat <= 597)
m.addConstraint(10 * grams_of_fiber <= 597)
m.addConstraint(25 * milligrams_of_calcium <= 597)

m.addConstraint(17 * milligrams_of_potassium <= 529)
m.addConstraint(24 * grams_of_fat <= 529)
m.addConstraint(19 * grams_of_fiber <= 529)
m.addConstraint(26 * milligrams_of_calcium <= 529)

m.addConstraint(13 * milligrams_of_potassium <= 533)
m.addConstraint(15 * grams_of_fat <= 533)
m.addConstraint(28 * grams_of_fiber <= 533)
m.addConstraint(23 * milligrams_of_calcium <= 533)

m.addConstraint(16 * milligrams_of_potassium <= 571)
m.addConstraint(27 * grams_of_fat <= 571)
m.addConstraint(27 * grams_of_fiber <= 571)
m.addConstraint(29 * milligrams_of_calcium <= 571)

# Combined immune support index constraints
m.addConstraint(25 * grams_of_fat + 25 * milligrams_of_calcium >= 116)
m.addConstraint(25 * grams_of_fat + 10 * grams_of_fiber >= 90)
m.addConstraint(24 * milligrams_of_potassium + 25 * milligrams_of_calcium >= 97)
m.addConstraint(10 * grams_of_fiber + 25 * milligrams_of_calcium >= 97)
m.addConstraint(24 * milligrams_of_potassium + 10 * grams_of_fiber + 25 * milligrams_of_calcium >= 109)
m.addConstraint(24 * milligrams_of_potassium + 25 * grams_of_fat + 10 * grams_of_fiber >= 109)
m.addConstraint(24 * milligrams_of_potassium + 10 * grams_of_fiber + 25 * milligrams_of_calcium >= 106)
m.addConstraint(24 * milligrams_of_potassium + 25 * grams_of_fat + 10 * grams_of_fiber >= 106)

# Cardiovascular support index constraints
m.addConstraint(24 * grams_of_fiber + 26 * milligrams_of_calcium >= 117)
m.addConstraint(17 * milligrams_of_potassium + 26 * milligrams_of_calcium >= 104)
m.addConstraint(24 * grams_of_fat + 19 * grams_of_fiber >= 90)
m.addConstraint(17 * milligrams_of_potassium + 24 * grams_of_fat >= 113)
m.addConstraint(24 * grams_of_fat + 26 * milligrams_of_calcium >= 71)
m.addConstraint(17 * milligrams_of_potassium + 24 * grams_of_fat + 26 * milligrams_of_calcium >= 96)
m.addConstraint(24 * grams_of_fat + 19 * grams_of_fiber + 26 * milligrams_of_calcium >= 96)
m.addConstraint(17 * milligrams_of_potassium + 24 * grams_of_fat + 19 * grams_of_fiber >= 96)
m.addConstraint(17 * milligrams_of_potassium + 24 * grams_of_fat + 26 * milligrams_of_calcium >= 80)
m.addConstraint(24 * grams_of_fat + 19 * grams_of_fiber + 26 * milligrams_of_calcium >= 80)
m.addConstraint(17 * milligrams_of_potassium + 24 * grams_of_fat + 19 * grams_of_fiber >= 80)
m.addConstraint(17 * milligrams_of_potassium + 24 * grams_of_fat + 26 * milligrams_of_calcium >= 77)
m.addConstraint(24 * grams_of_fat + 19 * grams_of_fiber + 26 * milligrams_of_calcium >= 77)
m.addConstraint(17 * milligrams_of_potassium + 24 * grams_of_fat + 19 * grams_of_fiber >= 77)

# Cognitive performance index constraints
m.addConstraint(15 * grams_of_fat + 28 * grams_of_fiber >= 70)
m.addConstraint(-2 * milligrams_of_potassium + 9 * grams_of_fat + 6 * grams_of_fiber >= 0)

# Upper bounds for immune support index
m.addConstraint(24 * milligrams_of_potassium + 25 * milligrams_of_calcium <= 537)
m.addConstraint(25 * grams_of_fat + 25 * milligrams_of_calcium <= 379)
m.addConstraint(10 * grams_of_fiber + 25 * milligrams_of_calcium <= 255)
m.addConstraint(24 * milligrams_of_potassium + 25 * grams_of_fat + 10 * grams_of_fiber + 25 * milligrams_of_calcium <= 255)

# Upper bounds for cardiovascular support index
m.addConstraint(19 * grams_of_fiber + 26 * milligrams_of_calcium <= 462)
m.addConstraint(24 * grams_of_fat + 19 * grams_of_fiber <= 403)
m.addConstraint(24 * grams_of_fat + 26 * milligrams_of_calcium <= 474)
m.addConstraint(17 * milligrams_of_potassium + 26 * milligrams_of_calcium <= 290)
m.addConstraint(17 * milligrams_of_potassium + 24 * grams_of_fat <= 195)
m.addConstraint(17 * milligrams_of_potassium + 24 * grams_of_fat + 19 * grams_of_fiber <= 499)
m.addConstraint(17 * milligrams_of_potassium + 19 * grams_of_fiber + 26 * milligrams_of_calcium <= 405)
m.addConstraint(17 * milligrams_of_potassium + 24 * grams_of_fat + 26 * milligrams_of_calcium <= 256)
m.addConstraint(17 * milligrams_of_potassium + 24 * grams_of_fat + 19 * grams_of_fiber + 26 * milligrams_of_calcium <= 256)

# Upper bounds for cognitive performance index
m.addConstraint(13 * milligrams_of_potassium + 28 * grams_of_fiber <= 151)
m.addConstraint(15 * grams_of_fat + 23 * milligrams_of_calcium <= 154)
m.addConstraint(13 * milligrams_of_potassium + 23 * milligrams_of_calcium <= 159)
m.addConstraint(15 * grams_of_fat + 28 * grams_of_fiber <= 201)
m.addConstraint(13 * milligrams_of_potassium + 15 * grams_of_fat + 28 * grams_of_fiber <= 413)
m.addConstraint(13 * milligrams_of_potassium + 15 * grams_of_fat + 23 * milligrams_of_calcium <= 266)
m.addConstraint(13 * milligrams_of_potassium + 15 * grams_of_fat + 28 * grams_of_fiber + 23 * milligrams_of_calcium <= 266)

# Upper bounds for energy stability index
m.addConstraint(16 * milligrams_of_potassium + 27 * grams_of_fat <= 437)
m.addConstraint(16 * milligrams_of_potassium + 27 * grams_of_fiber <= 256)
m.addConstraint(16 * milligrams_of_potassium + 29 * milligrams_of_calcium <= 304)
m.addConstraint(27 * grams_of_fat + 27 * grams_of_fiber <= 313)
m.addConstraint(27 * grams_of_fiber + 29 * milligrams_of_calcium <= 400)
m.addConstraint(16 * milligrams_of_potassium + 27 * grams_of_fat + 27 * grams_of_fiber <= 265)
m.addConstraint(16 * milligrams_of_potassium + 27 * grams_of_fat + 29 * milligrams_of_calcium <= 207)
m.addConstraint(16 * milligrams_of_potassium + 27 * grams_of_fat + 27 * grams_of_fiber + 29 * milligrams_of_calcium <= 207)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print("Milligrams of potassium: ", milligrams_of_potassium.varValue)
    print("Grams of fat: ", grams_of_fat.varValue)
    print("Grams of fiber: ", grams_of_fiber.varValue)
    print("Milligrams of calcium: ", milligrams_of_calcium.varValue)
    print("Objective: ", m.objVal)
else:
    print("No optimal solution found.")
