
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Work_Optimization")

# Create variables
george_hours = m.addVar(vtype=GRB.INTEGER, name="george_hours")
ringo_hours = m.addVar(vtype=GRB.INTEGER, name="ringo_hours")
bobby_hours = m.addVar(vtype=GRB.INTEGER, name="bobby_hours")
jean_hours = m.addVar(vtype=GRB.INTEGER, name="jean_hours")
mary_hours = m.addVar(vtype=GRB.INTEGER, name="mary_hours")
laura_hours = m.addVar(vtype=GRB.CONTINUOUS, name="laura_hours")


# Set objective function
m.setObjective(5 * george_hours + 2 * ringo_hours + 4 * bobby_hours + 9 * jean_hours + 9 * mary_hours + 5 * laura_hours, GRB.MAXIMIZE)

# Likelihood to quit index constraints
likelihood_to_quit = {'George': 16, 'Ringo': 15, 'Bobby': 12, 'Jean': 6, 'Mary': 7, 'Laura': 16}
m.addConstr(6 * jean_hours + 7 * mary_hours >= 84)
m.addConstr(15 * ringo_hours + 7 * mary_hours >= 89)
m.addConstr(16 * george_hours + 7 * mary_hours >= 86)
m.addConstr(15 * ringo_hours + 6 * jean_hours >= 82)
m.addConstr(15 * ringo_hours + 6 * jean_hours + 16 * laura_hours >= 95)
m.addConstr(16 * george_hours + 15 * ringo_hours + 16 * laura_hours >= 95)
m.addConstr(6 * jean_hours + 7 * mary_hours + 16 * laura_hours >= 95)
m.addConstr(16 * george_hours + 12 * bobby_hours + 16 * laura_hours >= 95)
m.addConstr(15 * ringo_hours + 6 * jean_hours + 16 * laura_hours >= 89)
m.addConstr(16 * george_hours + 15 * ringo_hours + 16 * laura_hours >= 89)
m.addConstr(6 * jean_hours + 7 * mary_hours + 16 * laura_hours >= 89)
m.addConstr(16 * george_hours + 12 * bobby_hours + 16 * laura_hours >= 89)
m.addConstr(15 * ringo_hours + 6 * jean_hours + 16 * laura_hours >= 77)
m.addConstr(16 * george_hours + 15 * ringo_hours + 16 * laura_hours >= 77)
m.addConstr(6 * jean_hours + 7 * mary_hours + 16 * laura_hours >= 77)
m.addConstr(16 * george_hours + 12 * bobby_hours + 16 * laura_hours >= 77)
m.addConstr(15 * ringo_hours + 6 * jean_hours + 16 * laura_hours >= 74)
m.addConstr(16 * george_hours + 15 * ringo_hours + 16 * laura_hours >= 74)
m.addConstr(6 * jean_hours + 7 * mary_hours + 16 * laura_hours >= 74)
m.addConstr(16 * george_hours + 12 * bobby_hours + 16 * laura_hours >= 74)


# ... (Similarly add other constraints for productivity, work quality, computer competence) ...
# Resource upper bound constraints
resource_upper_bounds = {'r0': 584, 'r1': 508, 'r2': 200, 'r3': 446}
resource_coefficients = {
    'r0': {'George': 16, 'Ringo': 15, 'Bobby': 12, 'Jean': 6, 'Mary': 7, 'Laura': 16},
    'r1': {'George': 3, 'Ringo': 7, 'Bobby': 8, 'Jean': 5, 'Mary': 17, 'Laura': 15},
    'r2': {'George': 16, 'Ringo': 2, 'Bobby': 1, 'Jean': 10, 'Mary': 9, 'Laura': 19},
    'r3': {'George': 8, 'Ringo': 6, 'Bobby': 10, 'Jean': 3, 'Mary': 5, 'Laura': 5}
}

for resource, upper_bound in resource_upper_bounds.items():
    m.addConstr(
        resource_coefficients[resource]['George'] * george_hours +
        resource_coefficients[resource]['Ringo'] * ringo_hours +
        resource_coefficients[resource]['Bobby'] * bobby_hours +
        resource_coefficients[resource]['Jean'] * jean_hours +
        resource_coefficients[resource]['Mary'] * mary_hours +
        resource_coefficients[resource]['Laura'] * laura_hours <= upper_bound,
        f"{resource}_upper_bound"
    )
# ... (Add all the remaining constraints similarly)

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print('Model is infeasible')
else:
    print('Optimization ended with status %d' % m.status)

