
from gurobipy import *

# Create a new model
m = Model("Employee_Hours")

# Define variables for hours worked by each employee
George = m.addVar(vtype=GRB.INTEGER, name="George")
Ringo = m.addVar(vtype=GRB.INTEGER, name="Ringo")
Bobby = m.addVar(vtype=GRB.INTEGER, name="Bobby")
Jean = m.addVar(vtype=GRB.INTEGER, name="Jean")
Mary = m.addVar(vtype=GRB.INTEGER, name="Mary")
Laura = m.addVar(vtype=GRB.CONTINUOUS, name="Laura")

# Define constraints
# Productivity ratings (lower bounds)
m.addConstr(George + Ringo >= 69, "Productivity_George_Ringo")
m.addConstr(Mary + Laura >= 98, "Productivity_Mary_Laura")

# Work quality ratings (lower bounds)
m.addConstr(Bobby + Jean >= 75, "WorkQuality_Bobby_Jean")
m.addConstr(George + Ringo >= 88, "WorkQuality_George_Ringo")

# Computer competence ratings (lower bounds)
m.addConstr(George + Jean >= 65, "ComputerCompetence_George_Jean")
m.addConstr(Ringo + Bobby >= 71, "ComputerCompetence_Ringo_Bobby")

# Likelihood to quit index (upper bounds)
m.addConstr(George + Bobby <= 159, "LikelihoodToQuit_George_Bobby")
m.addConstr(Jean + Laura <= 155, "LikelihoodToQuit_Jean_Laura")

# Other constraints
m.addConstr(Ringo + Jean <= 161, "Productivity_Ringo_Jean")
m.addConstr(Mary + Laura <= 314, "Productivity_Mary_Laura")

# Objective: Minimize total combined productivity rating (example)
m.setObjective(George + Ringo + Bobby + Jean + Mary + Laura, GRB.MINIMIZE)

# Optimize model
m.optimize()

# Print solution
for v in m.getVars():
    print('%s %g' % (v.varName, v.x))
