
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
apple_pies = m.addVar(lb=0, name="apple_pies")
chicken_thighs = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="chicken_thighs")
hamburgers = m.addVar(lb=0, name="hamburgers")
eggs = m.addVar(lb=0, name="eggs")

# Set objective function
m.setObjective(5.22 * apple_pies * chicken_thighs + 7.67 * apple_pies * eggs + 5.72 * chicken_thighs * hamburgers + 3.72 * chicken_thighs * eggs + 8.75 * apple_pies + 4.07 * eggs, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(5.76 * chicken_thighs + 4.74 * hamburgers >= 17, "c0")
m.addConstr(4.74 * hamburgers**2 + 3.35 * eggs**2 >= 26, "c1") # Note: Gurobi doesn't directly support squared variables in constraints. This needs to be reformulated if non-convexity is an issue.
m.addConstr(2.59 * apple_pies + 5.76 * chicken_thighs + 4.74 * hamburgers + 3.35 * eggs >= 26, "c2")
m.addConstr(9.41 * apple_pies + 6.55 * chicken_thighs >= 41, "c3")
m.addConstr(9.41 * apple_pies + 0.76 * hamburgers >= 53, "c4")
m.addConstr(9.41 * apple_pies + 4.79 * eggs >= 51, "c5")
m.addConstr(0.76 * hamburgers + 4.79 * eggs >= 42, "c6")
m.addConstr(6.55 * chicken_thighs + 0.76 * hamburgers >= 27, "c7")
m.addConstr(6.55 * chicken_thighs**2 + 4.79 * eggs**2 >= 58, "c8") # Note: Gurobi doesn't directly support squared variables in constraints. This needs to be reformulated if non-convexity is an issue.
m.addConstr(9.41 * apple_pies**2 + 6.55 * chicken_thighs**2 + 4.79 * eggs**2 >= 32, "c9") # Note: Gurobi doesn't directly support squared variables in constraints. This needs to be reformulated if non-convexity is an issue.
m.addConstr(9.41 * apple_pies + 6.55 * chicken_thighs + 0.76 * hamburgers + 4.79 * eggs >= 32, "c10")
m.addConstr(-3 * apple_pies + 6 * eggs >= 0, "c11")
m.addConstr(-10 * apple_pies + 6 * chicken_thighs >= 0, "c12")
m.addConstr(4.74 * hamburgers + 3.35 * eggs <= 33, "c13")
m.addConstr(2.59 * apple_pies + 5.76 * chicken_thighs + 4.74 * hamburgers <= 61, "c14")
m.addConstr(2.59 * apple_pies + 5.76 * chicken_thighs + 3.35 * eggs <= 48, "c15")
m.addConstr(5.76 * chicken_thighs + 4.74 * hamburgers + 3.35 * eggs <= 50, "c16")
m.addConstr(9.41 * apple_pies + 4.79 * eggs <= 195, "c17")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

