
from gurobipy import Model, GRB

# Create a new model
m = Model("resource_optimization")

# Create variables
pen_testers = m.addVar(vtype=GRB.INTEGER, name="pen_testers")
intrusion_analysts = m.addVar(vtype=GRB.INTEGER, name="intrusion_analysts")
soc_operators = m.addVar(vtype=GRB.INTEGER, name="soc_operators")

# Set objective function
m.setObjective(4 * pen_testers + 2 * intrusion_analysts + soc_operators, GRB.MINIMIZE)

# Add constraints
m.addConstr(9 * pen_testers + 8 * intrusion_analysts + 10 * soc_operators <= 182, "computational_load")
m.addConstr(9 * pen_testers + 21 * intrusion_analysts + 23 * soc_operators <= 190, "data_accessibility_impact")
m.addConstr(4 * pen_testers + 10 * intrusion_analysts + 12 * soc_operators <= 169, "power_consumption")
m.addConstr(11 * pen_testers + 23 * intrusion_analysts + 21 * soc_operators <= 230, "network_latency_impact")
m.addConstr(21 * pen_testers + 10 * intrusion_analysts + 23 * soc_operators <= 129, "available_bandwidth_impact")

m.addConstr(9 * pen_testers + 10 * soc_operators >= 48, "computational_load_min1")
m.addConstr(8 * intrusion_analysts + 10 * soc_operators >= 46, "computational_load_min2")
m.addConstr(9 * pen_testers + 8 * intrusion_analysts + 10 * soc_operators >= 46, "computational_load_min3")

m.addConstr(9 * pen_testers + 21 * intrusion_analysts >= 23, "data_accessibility_impact_min1")
m.addConstr(21 * intrusion_analysts + 23 * soc_operators >= 62, "data_accessibility_impact_min2")
m.addConstr(9 * pen_testers + 23 * soc_operators >= 21, "data_accessibility_impact_min3")
m.addConstr(9 * pen_testers + 21 * intrusion_analysts + 23 * soc_operators >= 21, "data_accessibility_impact_min4")

m.addConstr(4 * pen_testers + 12 * soc_operators >= 30, "power_consumption_min1")
m.addConstr(10 * intrusion_analysts + 12 * soc_operators >= 25, "power_consumption_min2")
m.addConstr(4 * pen_testers + 10 * intrusion_analysts + 12 * soc_operators >= 53, "power_consumption_min3")


m.addConstr(11 * pen_testers + 23 * intrusion_analysts >= 70, "network_latency_min1")
m.addConstr(11 * pen_testers + 21 * soc_operators >= 73, "network_latency_min2")
m.addConstr(11 * pen_testers + 23 * intrusion_analysts + 21 * soc_operators >= 73, "network_latency_min3")

m.addConstr(21 * pen_testers + 23 * soc_operators >= 35, "bandwidth_min1")
m.addConstr(21 * pen_testers + 10 * intrusion_analysts >= 27, "bandwidth_min2")
m.addConstr(21 * pen_testers + 10 * intrusion_analysts + 23 * soc_operators >= 30, "bandwidth_min3")

m.addConstr(intrusion_analysts - 7 * soc_operators >= 0, "custom_constraint1")
m.addConstr(-pen_testers + 3 * intrusion_analysts >= 0, "custom_constraint2")

m.addConstr(9 * pen_testers + 8 * intrusion_analysts + 10 * soc_operators <= 79, "computational_load_max")
m.addConstr(4 * pen_testers + 10 * intrusion_analysts <= 100, "power_consumption_max1")
m.addConstr(4 * pen_testers + 12 * soc_operators <= 95, "power_consumption_max2")
m.addConstr(10 * intrusion_analysts + 23 * soc_operators <= 123, "bandwidth_max1")
m.addConstr(21 * pen_testers + 23 * soc_operators <= 103, "bandwidth_max2")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('pen_testers:', pen_testers.x)
    print('intrusion_analysts:', intrusion_analysts.x)
    print('soc_operators:', soc_operators.x)
elif m.status == GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)
