
from gurobipy import *

# Create a model
m = Model("Optimization_Model")

# Define the decision variables
x0 = m.addVar(vtype=GRB.INTEGER, name="pen_testers")
x1 = m.addVar(vtype=GRB.INTEGER, name="intrusion_analysts")
x2 = m.addVar(vtype=GRB.INTEGER, name="SOC_operators")

# Define the objective function
m.setObjective(4*x0 + 2*x1 + x2, GRB.MINIMIZE)

# Constraints from the problem description

# Computational load constraints
m.addConstr(9*x0 + 8*x1 + 10*x2 >= 48, name="comp_load_1")
m.addConstr(8*x1 + 10*x2 >= 46, name="comp_load_2")
m.addConstr(9*x0 + 8*x1 + 10*x2 >= 46, name="comp_load_3")

# Data accessibility impact constraints
m.addConstr(9*x0 + 21*x1 >= 23, name="data_impact_1")
m.addConstr(21*x1 + 23*x2 >= 62, name="data_impact_2")
m.addConstr(9*x0 + 23*x2 >= 21, name="data_impact_3")
m.addConstr(9*x0 + 21*x1 + 23*x2 >= 21, name="data_impact_4")

# Power consumption constraints
m.addConstr(4*x0 + 12*x2 >= 30, name="power_consumption_1")
m.addConstr(10*x1 + 12*x2 >= 25, name="power_consumption_2")
m.addConstr((4*x0 + 10*x1 + 12*x2) >= 53, name="power_consumption_3")

# Network latency constraints
m.addConstr(11*x0 + 23*x1 >= 70, name="net_latency_1")
m.addConstr(11*x0 + 21*x2 >= 73, name="net_latency_2")
m.addConstr(11*x0 + 23*x1 + 21*x2 >= 73, name="net_latency_3")

# Available bandwidth constraints
m.addConstr(21*x0 + 23*x2 >= 35, name="bandwidth_1")
m.addConstr(21*x0 + 10*x1 >= 27, name="bandwidth_2")
m.addConstr((21*x0 + 10*x1 + 23*x2) >= 30, name="bandwidth_3")

# Additional constraints
m.addConstr(x1 - 7*x2 >= 0, name="additional_constraint_1")
m.addConstr(-x0 + 3*x1 >= 0, name="additional_constraint_2")

# Upper bound constraints for computational load and power consumption
m.addConstr(9*x0 + 8*x1 + 10*x2 <= 79, name="comp_load_max")
m.addConstr((4*x0 + 10*x1) <= 100, name="power_consumption_max_1")
m.addConstr((4*x0 + 12*x2) <= 95, name="power_consumption_max_2")

# Upper bound constraints for available bandwidth
m.addConstr((10*x1 + 23*x2) <= 123, name="bandwidth_max_1")
m.addConstr((21*x0 + 23*x2) <= 103, name="bandwidth_max_2")

# Solve the model
m.optimize()

for v in m.getVars():
    print('%s %g' % (v.varName, v.x))

print('Obj: %g' % m.objVal)
