
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    pen_testers = model.addVar(name="pen_testers", vtype=gurobi.GRB.INTEGER)
    intrusion_analysts = model.addVar(name="intrusion_analysts", vtype=gurobi.GRB.INTEGER)
    SOC_operators = model.addVar(name="SOC_operators", vtype=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(4 * pen_testers + 2 * intrusion_analysts + SOC_operators, gurobi.GRB.MINIMIZE)

    resources = {
        'r0': {'description': 'computational load', 'upper_bound': 182, 'x0': 9, 'x1': 8, 'x2': 10},
        'r1': {'description': 'data accessibility impact', 'upper_bound': 190, 'x0': 9, 'x1': 21, 'x2': 23},
        'r2': {'description': 'power consumption', 'upper_bound': 169, 'x0': 4, 'x1': 10, 'x2': 12},
        'r3': {'description': 'network latency impact', 'upper_bound': 230, 'x0': 11, 'x1': 23, 'x2': 21},
        'r4': {'description': 'available bandwidth impact', 'upper_bound': 129, 'x0': 21, 'x1': 10, 'x2': 23}
    }

    # Constraints
    # Computational load constraints
    model.addConstr(9 * pen_testers + 8 * intrusion_analysts + 10 * SOC_operators >= 48)
    model.addConstr(8 * intrusion_analysts + 10 * SOC_operators >= 46)
    model.addConstr(9 * pen_testers + 8 * intrusion_analysts + 10 * SOC_operators >= 46)
    model.addConstr(9 * pen_testers + 8 * intrusion_analysts + 10 * SOC_operators <= 79)

    # Data accessibility impact constraints
    model.addConstr(9 * pen_testers + 21 * intrusion_analysts >= 23)
    model.addConstr(21 * intrusion_analysts + 23 * SOC_operators >= 62)
    model.addConstr(9 * pen_testers + 23 * SOC_operators >= 21)
    model.addConstr(9 * pen_testers + 21 * intrusion_analysts + 23 * SOC_operators >= 21)

    # Power consumption constraints
    model.addConstr(4 * pen_testers + 12 * SOC_operators >= 30)
    model.addConstr(10 * intrusion_analysts + 12 * SOC_operators >= 25)
    model.addConstr(4 * pen_testers + 10 * intrusion_analysts + 12 * SOC_operators >= 53)
    model.addConstr(4 * pen_testers + 10 * intrusion_analysts + 12 * SOC_operators >= 53)
    model.addConstr(4 * pen_testers + 10 * intrusion_analysts <= 100)
    model.addConstr(4 * pen_testers + 12 * SOC_operators <= 95)

    # Network latency constraints
    model.addConstr(11 * pen_testers + 23 * intrusion_analysts >= 70)
    model.addConstr(11 * pen_testers + 21 * SOC_operators >= 73)
    model.addConstr(11 * pen_testers + 23 * intrusion_analysts + 21 * SOC_operators >= 73)

    # Available bandwidth constraints
    model.addConstr(21 * pen_testers + 10 * intrusion_analysts >= 27)
    model.addConstr(21 * pen_testers + 23 * SOC_operators >= 35)
    model.addConstr(21 * pen_testers + 10 * intrusion_analysts + 23 * SOC_operators >= 30)
    model.addConstr(10 * intrusion_analysts + 23 * SOC_operators <= 123)
    model.addConstr(21 * pen_testers + 23 * SOC_operators <= 103)

    # Additional constraints
    model.addConstr(intrusion_analysts - 7 * SOC_operators >= 0)
    model.addConstr(-pen_testers + 3 * intrusion_analysts >= 0)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objval)
        print("pen testers: ", pen_testers.varValue)
        print("intrusion analysts: ", intrusion_analysts.varValue)
        print("SOC operators: ", SOC_operators.varValue)
    else:
        print("Model is infeasible")

solve_optimization_problem()
