
from gurobipy import Model, GRB, quicksum

# Create a new model
m = Model("optimization_problem")

# Create variables
fruit_salads = m.addVar(vtype=GRB.INTEGER, name="fruit_salads")
strawberries = m.addVar(vtype=GRB.INTEGER, name="strawberries")
peanutbutter_sandwiches = m.addVar(vtype=GRB.INTEGER, name="peanutbutter_sandwiches")

# Set objective function
m.setObjective(
    1 * fruit_salads * fruit_salads
    + 3 * fruit_salads * strawberries
    + 5 * fruit_salads * peanutbutter_sandwiches
    + 9 * strawberries * strawberries
    + 8 * fruit_salads
    + 8 * strawberries,
    GRB.MAXIMIZE,
)

# Add constraints
m.addConstr(6 * fruit_salads + 15 * strawberries >= 68)
m.addConstr(15 * strawberries + 5 * peanutbutter_sandwiches >= 37)
m.addConstr(6 * fruit_salads + 5 * peanutbutter_sandwiches >= 27)
m.addConstr(5 * fruit_salads + 19 * peanutbutter_sandwiches >= 78)
m.addConstr(5 * fruit_salads + 1 * strawberries >= 40)
m.addConstr(15 * fruit_salads * fruit_salads + 7 * strawberries * strawberries >= 49)
m.addConstr(7 * strawberries + 12 * peanutbutter_sandwiches >= 88)
m.addConstr(15 * fruit_salads + 12 * peanutbutter_sandwiches >= 138)
m.addConstr(15 * strawberries + 5 * peanutbutter_sandwiches <= 196)
m.addConstr(6 * fruit_salads * fruit_salads + 5 * peanutbutter_sandwiches * peanutbutter_sandwiches <= 131)
m.addConstr(6 * fruit_salads + 15 * strawberries + 5 * peanutbutter_sandwiches <= 160)
m.addConstr(8 * fruit_salads + 20 * peanutbutter_sandwiches <= 140)
m.addConstr(8 * fruit_salads + 5 * strawberries <= 122)
m.addConstr(5 * fruit_salads * fruit_salads + 1 * strawberries * strawberries <= 232)
m.addConstr(5 * fruit_salads + 1 * strawberries + 19 * peanutbutter_sandwiches <= 232)
m.addConstr(7 * strawberries * strawberries + 12 * peanutbutter_sandwiches * peanutbutter_sandwiches <= 266)
m.addConstr(15 * fruit_salads * fruit_salads + 7 * strawberries * strawberries <= 160)
m.addConstr(15 * fruit_salads + 7 * strawberries + 12 * peanutbutter_sandwiches <= 160)


# Resource Constraints
m.addConstr(6 * fruit_salads + 15 * strawberries + 5 * peanutbutter_sandwiches <= 210) # Umami
m.addConstr(8 * fruit_salads + 5 * strawberries + 20 * peanutbutter_sandwiches <= 165) # Tastiness
m.addConstr(5 * fruit_salads + 1 * strawberries + 19 * peanutbutter_sandwiches <= 287) # Cost
m.addConstr(15 * fruit_salads + 7 * strawberries + 12 * peanutbutter_sandwiches <= 419) # Calcium


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Fruit Salads: {fruit_salads.x}")
    print(f"Strawberries: {strawberries.x}")
    print(f"Peanutbutter Sandwiches: {peanutbutter_sandwiches.x}")
    print(f"Objective Value: {m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

