
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
fruit_salads = m.addVar(name="fruit_salads", vtype=gp.GRB.INTEGER)
strawberries = m.addVar(name="strawberries", vtype=gp.GRB.INTEGER)
peanutbutter_sandwiches = m.addVar(name="peanutbutter_sandwiches", vtype=gp.GRB.INTEGER)

# Define the objective function
m.setObjective(fruit_salads**2 + 3 * fruit_salads * strawberries + 5 * fruit_salads * peanutbutter_sandwiches + 
               9 * strawberries**2 + 8 * fruit_salads + 8 * strawberries, gp.GRB.MAXIMIZE)

# Umami index constraints
m.addConstr(6 * fruit_salads + 15 * strawberries >= 68)
m.addConstr(15 * strawberries + 5 * peanutbutter_sandwiches >= 37)
m.addConstr(6 * fruit_salads + 5 * peanutbutter_sandwiches >= 27)
m.addConstr(15 * strawberries + 5 * peanutbutter_sandwiches <= 196)

# Tastiness rating constraints
m.addConstr(8 * fruit_salads + 20 * peanutbutter_sandwiches <= 140)
m.addConstr(8 * fruit_salads + 5 * strawberries <= 122)
m.addConstr(8 * fruit_salads + 5 * strawberries + 20 * peanutbutter_sandwiches <= 122)

# Cost constraints
m.addConstr(5 * fruit_salads + 19 * peanutbutter_sandwiches >= 78)
m.addConstr(5 * fruit_salads + strawberries >= 40)
m.addConstr(5 * fruit_salads + strawberries + 19 * peanutbutter_sandwiches <= 232)
m.addConstr(5 * fruit_salads**2 + strawberries**2 <= 232)

# Calcium constraints
m.addConstr(15 * fruit_salads**2 + 7 * strawberries**2 >= 49)
m.addConstr(7 * strawberries + 12 * peanutbutter_sandwiches >= 88)
m.addConstr(15 * fruit_salads + 12 * peanutbutter_sandwiches >= 138)
m.addConstr(7 * strawberries**2 + 12 * peanutbutter_sandwiches**2 <= 266)
m.addConstr(15 * fruit_salads**2 + 7 * strawberries**2 <= 160)
m.addConstr(15 * fruit_salads + 7 * strawberries + 12 * peanutbutter_sandwiches <= 160)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Fruit Salads: ", fruit_salads.varValue)
    print("Strawberries: ", strawberries.varValue)
    print("Peanutbutter Sandwiches: ", peanutbutter_sandwiches.varValue)
else:
    print("The model is infeasible")
