
from gurobipy import Model, GRB

# Create a new model
m = Model("vitamin_calcium_optimization")

# Create variables
vitamin_b3 = m.addVar(vtype=GRB.INTEGER, name="vitamin_b3")
calcium = m.addVar(vtype=GRB.CONTINUOUS, name="calcium")

# Create quadratic terms as new variables and constraints
vitamin_b3_sq = m.addVar(vtype=GRB.CONTINUOUS, name="vitamin_b3_sq")
calcium_sq = m.addVar(vtype=GRB.CONTINUOUS, name="calcium_sq")

m.addConstr(vitamin_b3_sq == vitamin_b3 * vitamin_b3)
m.addConstr(calcium_sq == calcium * calcium)


# Set objective
m.setObjective(vitamin_b3 * calcium + 9 * calcium_sq + 4 * vitamin_b3 + 3 * calcium, GRB.MAXIMIZE)

# Add constraints
m.addConstr(3 * vitamin_b3 + 3 * calcium >= 20, "muscle_growth_min")
m.addConstr(vitamin_b3_sq + calcium_sq >= 56, "cardio_support_min_sq")
m.addConstr(8 * vitamin_b3 + 11 * calcium >= 61, "digestive_support_min")
m.addConstr(6 * vitamin_b3_sq - 8 * calcium_sq >= 0, "quadratic_constraint")
m.addConstr(3 * vitamin_b3 + 3 * calcium <= 66, "muscle_growth_max")
m.addConstr(vitamin_b3_sq + calcium_sq <= 74, "cardio_support_max_sq")
m.addConstr(1 * vitamin_b3 + 4 * calcium <= 74, "cardio_support_max")
m.addConstr(8 * vitamin_b3_sq + 11 * calcium_sq <= 95, "digestive_support_max_sq")  # Using squared terms as specified
m.addConstr(8 * vitamin_b3 + 11 * calcium <= 95, "digestive_support_max")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('vitamin_b3:', vitamin_b3.x)
    print('calcium:', calcium.x)
elif m.status == GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print(f"Optimization terminated with status {m.status}")

