
import gurobi

def optimize_problem():
    model = gurobi.Model()

    x0 = model.addVar(name="milligrams of vitamin B3", vtype=gurobi.GRB.INTEGER)
    x1 = model.addVar(name="milligrams of calcium")

    model.setObjective(x0 * x1 + 9 * x1**2 + 4 * x0 + 3 * x1, gurobi.GRB.MAXIMIZE)

    model.addConstr(x0 == 1, name="constraint_x0")
    model.addConstr(3*x0 + 3*x1 >= 20, name="total_muscle_growth_index")
    model.addConstr(x0**2 + 4*x1**2 >= 56, name="total_cardiovascular_support_index")
    model.addConstr(8*x0 + 11*x1 >= 61, name="total_digestive_support_index")
    model.addConstr(6*x0**2 - 8*x1**2 >= 0, name="quadratic_constraint")
    model.addConstr(3*x0 + 3*x1 <= 66, name="total_muscle_growth_index_upper_bound")
    model.addConstr(x0**2 + 4*x1**2 <= 74, name="total_cardiovascular_support_index_upper_bound")
    model.addConstr(8*x0 + 11*x1 <= 95, name="total_digestive_support_index_upper_bound")

    model.optimize()

    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of vitamin B3: {x0.varValue}")
        print(f"Milligrams of calcium: {x1.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

optimize_problem()
