
import gurobipy as gp

# Create a new model
m = gp.Model("work_hours_optimization")

# Create variables
hank = m.addVar(lb=0, name="hank")
bill = m.addVar(lb=0, name="bill")
laura = m.addVar(lb=0, name="laura")
jean = m.addVar(lb=0, name="jean")

# Set objective function
m.setObjective(4.7 * hank**2 + 1.48 * hank * bill + 8.34 * hank * jean + 9.02 * bill**2 + 1.32 * bill * jean + 5.27 * bill, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(4 * hank**2 + 9 * bill**2 + 6 * jean**2 >= 28, "c1")
m.addConstr(9 * bill + 3 * laura + 6 * jean >= 28, "c2")
m.addConstr(4 * hank + 9 * bill + 6 * jean >= 21, "c3")
m.addConstr(9 * bill + 3 * laura + 6 * jean >= 21, "c4")
m.addConstr(3 * laura + 6 * jean <= 79, "c5")
m.addConstr(4 * hank + 3 * laura <= 159, "c6")
m.addConstr(4 * hank**2 + 6 * jean**2 <= 63, "c7")
m.addConstr(4 * hank**2 + 9 * bill**2 <= 45, "c8")
m.addConstr(9 * bill + 6 * jean <= 145, "c9")
m.addConstr(4 * hank + 9 * bill + 3 * laura <= 70, "c10")
m.addConstr(4 * hank + 3 * laura + 6 * jean <= 133, "c11")
m.addConstr(4 * hank + 9 * bill + 3 * laura + 6 * jean <= 133, "c12")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

