
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
H = m.addVar(lb=-gp.GRB.INFINITY, name="hours_worked_by_Hank")
B = m.addVar(lb=-gp.GRB.INFINITY, name="hours_worked_by_Bill")
L = m.addVar(lb=-gp.GRB.INFINITY, name="hours_worked_by_Laura")
J = m.addVar(lb=-gp.GRB.INFINITY, name="hours_worked_by_Jean")

# Objective function
m.setObjective(4.7 * H**2 + 1.48 * H * B + 8.34 * H * J + 9.02 * B**2 + 1.32 * B * J + 5.27 * B, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(H * 4 <= 161, "Hank_computer_competence")
m.addConstr(B * 9 <= 161, "Bill_computer_competence")
m.addConstr(L * 3 <= 161, "Laura_computer_competence")
m.addConstr(J * 6 <= 161, "Jean_computer_competence")

m.addConstr(H**2 + B**2 + J**2 >= 28, "total_computer_competence_rating_squared")
m.addConstr(B + L + J >= 28, "total_B_L_J_computer_competence")
m.addConstr(H + B + J >= 21, "total_H_B_J_computer_competence")
m.addConstr(B + L + J >= 21, "total_B_L_J_computer_competence_alternate")
m.addConstr(L + J <= 79, "L_J_computer_competence_max")
m.addConstr(H + L <= 159, "H_L_computer_competence_max")
m.addConstr(H**2 + J**2 <= 63, "H_J_computer_competence_squared_max")
m.addConstr(H**2 + B**2 <= 45, "H_B_computer_competence_squared_max")
m.addConstr(B * J <= 145, "B_J_computer_competence_max")
m.addConstr(H + B + L <= 70, "H_B_L_computer_competence_max")
m.addConstr(H + L + J <= 133, "H_L_J_computer_competence_max")
m.addConstr(H + B + L + J <= 133, "total_computer_competence_max")

# Solve the problem
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("H: ", H.varValue)
    print("B: ", B.varValue)
    print("L: ", L.varValue)
    print("J: ", J.varValue)
else:
    print("The problem is infeasible")
