
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("nutrition_optimization")

    # Create variables
    x0 = m.addVar(name="milligrams of vitamin B3")  # Vitamin B3
    x1 = m.addVar(name="grams of fiber")  # Fiber

    # Set objective function
    m.setObjective(9.44 * x0 + 6.86 * x1, GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(3 * x0 + 2 * x1 >= 17, "digestive_support_lower")
    m.addConstr(4 * x0 + 5 * x1 >= 12, "kidney_support_lower")
    m.addConstr(2 * x0 + 1 * x1 >= 15, "cognitive_performance_lower")
    m.addConstr(1 * x0 + 3 * x1 >= 2, "muscle_growth_lower")
    m.addConstr(3 * x0 + 3 * x1 >= 8, "immune_support_lower")
    m.addConstr(5 * x0 - 3 * x1 >= 0, "custom_constraint")

    m.addConstr(3 * x0 + 2 * x1 <= 34, "digestive_support_upper") # Combined redundant constraints
    m.addConstr(4 * x0 + 5 * x1 <= 34, "kidney_support_upper") # Combined redundant constraints
    m.addConstr(2 * x0 + 1 * x1 <= 44, "cognitive_performance_upper") # Combined redundant constraints
    m.addConstr(1 * x0 + 3 * x1 <= 10, "muscle_growth_upper") # Combined redundant constraints
    m.addConstr(3 * x0 + 3 * x1 <= 20, "immune_support_upper") # Combined redundant constraints


    # Optimize model
    m.optimize()

    # Print results
    if m.status == GRB.OPTIMAL:
        print(f"Optimal objective value: {m.objVal}")
        print(f"Milligrams of vitamin B3: {x0.x}")
        print(f"Grams of fiber: {x1.x}")
    elif m.status == GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {m.status}")


except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
