
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(name="milligrams_of_vitamin_B3", lb=0)  # milligrams of vitamin B3
x1 = m.addVar(name="grams_of_fiber", lb=0)  # grams of fiber

# Objective function: maximize 9.44*x0 + 6.86*x1
m.setObjective(9.44 * x0 + 6.86 * x1, GRB.MAXIMIZE)

# Constraints:
# Digestive support index constraints
m.addConstr(3*x0 + 2*x1 >= 17, name="digestive_support_min")
m.addConstr(3*x0 + 2*x1 <= 34, name="digestive_support_max")

# Kidney support index constraints
m.addConstr(4*x0 + 5*x1 >= 12, name="kidney_support_min")
m.addConstr(4*x0 + 5*x1 <= 34, name="kidney_support_max")

# Cognitive performance index constraints
m.addConstr(2*x0 + x1 >= 15, name="cognitive_performance_min")
m.addConstr(2*x0 + x1 <= 44, name="cognitive_performance_max")

# Muscle growth index constraints
m.addConstr(x0 + 3*x1 >= 2, name="muscle_growth_min")
m.addConstr(x0 + 3*x1 <= 10, name="muscle_growth_max")

# Immune support index constraints
m.addConstr(3*x0 + 3*x1 >= 8, name="immune_support_min")
m.addConstr(3*x0 + 3*x1 <= 20, name="immune_support_max")

# Additional linear constraint
m.addConstr(5*x0 - 3*x1 >= 0, name="additional_constraint")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Milligrams of Vitamin B3: {x0.x}")
    print(f"Grams of Fiber: {x1.x}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("No optimal solution found.")
