
import gurobi

# Create a new Gurobi model
model = gurobi.Model()

# Define variables
milligrams_vitamin_B3 = model.addVar(name="milligrams_vitamin_B3", lb=0)  # No lower bound specified, assuming 0
grams_fiber = model.addVar(name="grams_fiber", lb=0)  # No lower bound specified, assuming 0

# Objective function: Maximize 9.44 * milligrams_vitamin_B3 + 6.86 * grams_fiber
model.setObjective(9.44 * milligrams_vitamin_B3 + 6.86 * grams_fiber, gurobi.GRB.MAXIMIZE)

# Constraints
# Digestive support index: 3 * milligrams_vitamin_B3 + 2 * grams_fiber >= 17
model.addConstr(3 * milligrams_vitamin_B3 + 2 * grams_fiber >= 17, name="digestive_support_min")

# Kidney support index: 4 * milligrams_vitamin_B3 + 5 * grams_fiber >= 12
model.addConstr(4 * milligrams_vitamin_B3 + 5 * grams_fiber >= 12, name="kidney_support_min")

# Cognitive performance index: 2 * milligrams_vitamin_B3 + 1 * grams_fiber >= 15
model.addConstr(2 * milligrams_vitamin_B3 + 1 * grams_fiber >= 15, name="cognitive_performance_min")

# Muscle growth index: 1 * milligrams_vitamin_B3 + 3 * grams_fiber >= 2
model.addConstr(1 * milligrams_vitamin_B3 + 3 * grams_fiber >= 2, name="muscle_growth_min")

# Immune support index: 3 * milligrams_vitamin_B3 + 3 * grams_fiber >= 8
model.addConstr(3 * milligrams_vitamin_B3 + 3 * grams_fiber >= 8, name="immune_support_min")

# 5 * milligrams_vitamin_B3 - 3 * grams_fiber >= 0
model.addConstr(5 * milligrams_vitamin_B3 - 3 * grams_fiber >= 0, name="vitamin_fiber_balance")

# Digestive support index upper bound: 3 * milligrams_vitamin_B3 + 2 * grams_fiber <= 34
model.addConstr(3 * milligrams_vitamin_B3 + 2 * grams_fiber <= 34, name="digestive_support_max")

# Kidney support index upper bound: 4 * milligrams_vitamin_B3 + 5 * grams_fiber <= 34
model.addConstr(4 * milligrams_vitamin_B3 + 5 * grams_fiber <= 34, name="kidney_support_max")

# Cognitive performance index upper bound: 2 * milligrams_vitamin_B3 + 1 * grams_fiber <= 44
model.addConstr(2 * milligrams_vitamin_B3 + 1 * grams_fiber <= 44, name="cognitive_performance_max")

# Muscle growth index upper bound: 1 * milligrams_vitamin_B3 + 3 * grams_fiber <= 10
model.addConstr(1 * milligrams_vitamin_B3 + 3 * grams_fiber <= 10, name="muscle_growth_max")

# Immune support index upper bound: 3 * milligrams_vitamin_B3 + 3 * grams_fiber <= 20
model.addConstr(3 * milligrams_vitamin_B3 + 3 * grams_fiber <= 20, name="immune_support_max")

# Optimize
model.optimize()

# Print solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Milligrams of Vitamin B3: {milligrams_vitamin_B3.varValue}")
    print(f"Grams of Fiber: {grams_fiber.varValue}")
    print(f"Objective: {model.objVal}")
else:
    print("No optimal solution found.")
