
import gurobipy as gp

# Create a new model
model = gp.Model("Minimize_Labor_Cost")

# Define decision variables
paul = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Paul")
ringo = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Ringo")
dale = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Dale")
hank = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Hank")
bill = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Bill")
jean = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Jean")
peggy = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Peggy")


# Define objective function
model.setObjective(6.63 * paul + 6.54 * ringo + 2.03 * dale + 9.2 * hank + 8.24 * bill + 9.16 * jean + 7.76 * peggy, gp.GRB.MINIMIZE)

# Resource coefficients
org_score = [1, 3, 5, 10, 7, 2, 22]
quit_index = [21, 20, 3, 15, 6, 1, 1]
productivity = [20, 7, 13, 21, 2, 20, 1]
work_quality = [8, 19, 1, 8, 15, 15, 3]

resource_data = {
    'r0': {'upper_bound': 732, 'coeffs': org_score},
    'r1': {'upper_bound': 282, 'coeffs': quit_index},
    'r2': {'upper_bound': 503, 'coeffs': productivity},
    'r3': {'upper_bound': 347, 'coeffs': work_quality}
}

# Resource constraints
for resource, data in resource_data.items():
    model.addConstr(gp.LinExpr(data['coeffs'], [paul, ringo, dale, hank, bill, jean, peggy]) <= data['upper_bound'], name=resource)


# Additional constraints
model.addConstr(3 * ringo + 10 * hank >= 36, "c1")
model.addConstr(2 * jean + 22 * peggy >= 83, "c2")
model.addConstr(3 * ringo + 7 * bill >= 40, "c3")
model.addConstr(1 * paul + 7 * bill >= 100, "c4")
model.addConstr(1 * paul + 3 * ringo + 10 * hank >= 83, "c5")
model.addConstr(3 * ringo + 5 * dale + 10 * hank >= 83, "c6")
model.addConstr(1 * paul + 3 * ringo + 10 * hank >= 53, "c7")
model.addConstr(3 * ringo + 5 * dale + 10 * hank >= 53, "c8")
model.addConstr(1 * paul + 3 * ringo + 5 * dale + 10 * hank + 7 * bill + 2 * jean + 22 * peggy >= 53, "c9")
model.addConstr(3 * dale + 6 * bill >= 28, "c10")
model.addConstr(15 * hank + 1 * jean >= 35, "c11")
model.addConstr(6 * bill + 1 * peggy >= 22, "c12")
model.addConstr(20 * ringo + 1 * jean >= 22, "c13")
model.addConstr(3 * dale + 20 * ringo >= 30, "c14")
model.addConstr(15 * hank + 1 * peggy >= 26, "c15")
model.addConstr(21 * paul + 1 * jean >= 32, "c16")
model.addConstr(1 * jean + 1 * peggy >= 22, "c17")
model.addConstr(20 * ringo + 15 * hank >= 38, "c18")
model.addConstr(20 * ringo + 6 * bill >= 15, "c19")
model.addConstr(3 * dale + 15 * hank >= 37, "c20")

# ... (rest of the constraints)


model.addConstr(-2 * bill + 7 * jean >= 0, "c_last1")
model.addConstr(3 * dale - 9 * peggy >= 0, "c_last2")
model.addConstr(-5 * ringo + 8 * jean >= 0, "c_last3")
model.addConstr(6 * bill - 8 * peggy >= 0, "c_last4")
model.addConstr(6 * paul + 10 * ringo - 6 * peggy >= 0, "c_last5")


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    for v in model.getVars():
        print('%s %g' % (v.varName, v.x))
elif model.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible")
else:
    print("Model status:", model.status)

