
import gurobi as gp

# Define variables
hours_worked_by_Paul = gp.Var(name='hours_worked_by_Paul', lb=0)
hours_worked_by_Ringo = gp.Var(name='hours_worked_by_Ringo', lb=0)
hours_worked_by_Dale = gp.Var(name='hours_worked_by_Dale', lb=0)
hours_worked_by_Hank = gp.Var(name='hours_worked_by_Hank', lb=0)
hours_worked_by_Bill = gp.Var(name='hours_worked_by_Bill', lb=0)
hours_worked_by_Jean = gp.Var(name='hours_worked_by_Jean', lb=0)
hours_worked_by_Peggy = gp.Var(name='hours_worked_by_Peggy', lb=0)

# Define model
m = gp.Model()

# Add variables to model
m.addVar(hours_worked_by_Paul)
m.addVar(hours_worked_by_Ringo)
m.addVar(hours_worked_by_Dale)
m.addVar(hours_worked_by_Hank)
m.addVar(hours_worked_by_Bill)
m.addVar(hours_worked_by_Jean)
m.addVar(hours_worked_by_Peggy)

# Objective function
m.setObjective(6.63 * hours_worked_by_Paul + 6.54 * hours_worked_by_Ringo + 2.03 * hours_worked_by_Dale + 
               9.2 * hours_worked_by_Hank + 8.24 * hours_worked_by_Bill + 9.16 * hours_worked_by_Jean + 
               7.76 * hours_worked_by_Peggy, gp.GRB.MINIMIZE)

# Constraints
# Organization score constraints
m.addConstr(1 * hours_worked_by_Paul + 3 * hours_worked_by_Ringo + 5 * hours_worked_by_Dale + 
             10 * hours_worked_by_Hank + 7 * hours_worked_by_Bill + 2 * hours_worked_by_Jean + 
             22 * hours_worked_by_Peggy <= 732)
m.addConstr(3 * hours_worked_by_Ringo + 10 * hours_worked_by_Hank >= 36)
m.addConstr(3 * hours_worked_by_Ringo + 7 * hours_worked_by_Bill >= 40)
m.addConstr(1 * hours_worked_by_Paul + 7 * hours_worked_by_Bill >= 100)
m.addConstr(1 * hours_worked_by_Paul + 3 * hours_worked_by_Ringo + 10 * hours_worked_by_Hank >= 83)
m.addConstr(3 * hours_worked_by_Ringo + 5 * hours_worked_by_Dale + 10 * hours_worked_by_Hank >= 83)
m.addConstr(1 * hours_worked_by_Paul + 3 * hours_worked_by_Ringo + 10 * hours_worked_by_Hank >= 53)
m.addConstr(1 * hours_worked_by_Paul + 3 * hours_worked_by_Ringo + 5 * hours_worked_by_Dale + 
             10 * hours_worked_by_Hank >= 53)
m.addConstr(1 * hours_worked_by_Paul + 3 * hours_worked_by_Ringo + 5 * hours_worked_by_Dale + 
             10 * hours_worked_by_Hank + 7 * hours_worked_by_Bill + 2 * hours_worked_by_Jean + 
             22 * hours_worked_by_Peggy >= 53)

# Likelihood to quit index constraints
m.addConstr(21 * hours_worked_by_Paul + 20 * hours_worked_by_Ringo + 3 * hours_worked_by_Dale + 
             15 * hours_worked_by_Hank + 6 * hours_worked_by_Bill + 1 * hours_worked_by_Jean + 
             1 * hours_worked_by_Peggy <= 282)
m.addConstr(20 * hours_worked_by_Ringo + 3 * hours_worked_by_Dale + 15 * hours_worked_by_Hank + 
             6 * hours_worked_by_Bill + 1 * hours_worked_by_Jean + 1 * hours_worked_by_Peggy <= 282)

# Productivity rating constraints
m.addConstr(20 * hours_worked_by_Paul + 7 * hours_worked_by_Ringo + 13 * hours_worked_by_Dale + 
             21 * hours_worked_by_Hank + 2 * hours_worked_by_Bill + 20 * hours_worked_by_Jean + 
             1 * hours_worked_by_Peggy <= 503)

# Work quality rating constraints
m.addConstr(8 * hours_worked_by_Paul + 19 * hours_worked_by_Ringo + 1 * hours_worked_by_Dale + 
             8 * hours_worked_by_Hank + 15 * hours_worked_by_Bill + 15 * hours_worked_by_Jean + 
             3 * hours_worked_by_Peggy <= 347)

# Solve model
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    print('Objective: ', m.objval)
    print('Hours worked by Paul: ', hours_worked_by_Paul.varValue)
    print('Hours worked by Ringo: ', hours_worked_by_Ringo.varValue)
    print('Hours worked by Dale: ', hours_worked_by_Dale.varValue)
    print('Hours worked by Hank: ', hours_worked_by_Hank.varValue)
    print('Hours worked by Bill: ', hours_worked_by_Bill.varValue)
    print('Hours worked by Jean: ', hours_worked_by_Jean.varValue)
    print('Hours worked by Peggy: ', hours_worked_by_Peggy.varValue)
else:
    print('No solution found')
