
import gurobipy as gp

# Create a new model
m = gp.Model("vitamin_optimization")

# Create variables
vitamin_d = m.addVar(lb=0, name="vitamin_d")
calcium = m.addVar(lb=0, name="calcium")
vitamin_b2 = m.addVar(lb=0, name="vitamin_b2")

# Set objective function
m.setObjective(6.46 * vitamin_d + 1.98 * calcium + 6.73 * vitamin_b2, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(23 * vitamin_d + 33 * vitamin_b2 >= 28, "c1")
m.addConstr(23 * vitamin_d + 34 * calcium >= 51, "c2")
m.addConstr(23 * vitamin_d + 34 * calcium + 33 * vitamin_b2 >= 51, "c3")
m.addConstr(10 * vitamin_d + 9 * vitamin_b2 >= 23, "c4")
m.addConstr(10 * vitamin_d + 11 * calcium >= 20, "c5")
m.addConstr(11 * calcium + 9 * vitamin_b2 >= 40, "c6")
m.addConstr(10 * vitamin_d + 11 * calcium + 9 * vitamin_b2 >= 46, "c7")
m.addConstr(10 * vitamin_d + 11 * calcium + 9 * vitamin_b2 >= 46, "c8") # Redundant constraint
m.addConstr(23 * vitamin_d + 33 * vitamin_b2 <= 168, "c9")


# Resource Constraints (implied by individual component constraints)
# m.addConstr(23 * vitamin_d + 34 * calcium + 33 * vitamin_b2 <= 191, "r0")
# m.addConstr(10 * vitamin_d + 11 * calcium + 9 * vitamin_b2 <= 173, "r1")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('vitamin_d:', vitamin_d.x)
    print('calcium:', calcium.x)
    print('vitamin_b2:', vitamin_b2.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

