
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables - since they can be fractional, we use continuous type
vitamin_D = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="milligrams_of_vitamin_D")
calcium = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="milligrams_of_calcium")
vitamin_B2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="milligrams_of_vitamin_B2")

# Objective function: Minimize
m.setObjective(6.46 * vitamin_D + 1.98 * calcium + 6.73 * vitamin_B2, GRB.MINIMIZE)

# Constraints
# Minimum combined cardiovascular support indices
m.addConstr(23 * vitamin_D + 33 * vitamin_B2 >= 28, name="cardio_support_vitD_vitB2_min")
m.addConstr(23 * vitamin_D + 34 * calcium >= 51, name="cardio_support_vitD_calcium_min")
m.addConstr(23 * vitamin_D + 34 * calcium + 33 * vitamin_B2 >= 51, name="cardio_support_all_min")

# Maximum combined cardiovascular support index for vit D and vit B2
m.addConstr(23 * vitamin_D + 33 * vitamin_B2 <= 168, name="cardio_support_vitD_vitB2_max")

# Minimum combined muscle growth indices
m.addConstr(10 * vitamin_D + 9 * vitamin_B2 >= 23, name="muscle_growth_vitD_vitB2_min")
m.addConstr(10 * vitamin_D + 11 * calcium >= 20, name="muscle_growth_vitD_calcium_min")
m.addConstr(11 * calcium + 9 * vitamin_B2 >= 40, name="muscle_growth_calcium_vitB2_min")
m.addConstr(10 * vitamin_D + 11 * calcium + 9 * vitamin_B2 >= 46, name="muscle_growth_all_min")

# Optimize the model
m.optimize()

# Print results
for v in m.getVars():
    print(f"{v.varName}: {v.x}")

print("Obj:", m.objVal)
