
import gurobi

def optimize():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    vitamin_D = model.addVar(name="vitamin_D", lb=0)  # No upper bound given
    calcium = model.addVar(name="calcium", lb=0)    # No upper bound given
    vitamin_B2 = model.addVar(name="vitamin_B2", lb=0)  # No upper bound given

    # Objective function
    model.setObjective(6.46 * vitamin_D + 1.98 * calcium + 6.73 * vitamin_B2)

    # Constraints
    model.addConstr(23 * vitamin_D + 33 * vitamin_B2 >= 28, name="c1")
    model.addConstr(23 * vitamin_D + 34 * calcium >= 51, name="c2")
    model.addConstr(23 * vitamin_D + 34 * calcium + 33 * vitamin_B2 >= 51, name="c3")
    model.addConstr(10 * vitamin_D + 9 * vitamin_B2 >= 23, name="c4")
    model.addConstr(10 * vitamin_D + 11 * calcium >= 20, name="c5")
    model.addConstr(11 * calcium + 9 * vitamin_B2 >= 40, name="c6")
    model.addConstr(10 * vitamin_D + 11 * calcium + 9 * vitamin_B2 >= 46, name="c7")
    model.addConstr(23 * vitamin_D + 34 * calcium + 33 * vitamin_B2 <= 168, name="c8")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Objective: ", model.objval)
        print("Vitamin D: ", vitamin_D.x)
        print("Calcium: ", calcium.x)
        print("Vitamin B2: ", vitamin_B2.x)
    else:
        print("No optimal solution found")

optimize()
