
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("vitamin_optimization")

    # Create variables
    vitamin_b1 = m.addVar(name="vitamin_b1")
    vitamin_b5 = m.addVar(name="vitamin_b5")
    vitamin_b3 = m.addVar(name="vitamin_b3")
    vitamin_b2 = m.addVar(name="vitamin_b2")
    potassium = m.addVar(name="potassium")

    # Set objective function
    m.setObjective(2 * vitamin_b1 + 3 * vitamin_b5 + 3 * vitamin_b3 + 5 * vitamin_b2 + 9 * potassium, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(13 * vitamin_b1 + 21 * vitamin_b5 >= 46, "c1")
    m.addConstr(23 * vitamin_b3 + 16 * vitamin_b2 >= 37, "c2")
    m.addConstr(21 * vitamin_b5 + 16 * vitamin_b2 >= 33, "c3")
    m.addConstr(13 * vitamin_b1 + 23 * vitamin_b3 >= 51, "c4")
    m.addConstr(21 * vitamin_b5 + 23 * vitamin_b3 >= 59, "c5")
    m.addConstr(16 * vitamin_b2 + 9 * potassium >= 33, "c6")
    m.addConstr(13 * vitamin_b1 + 9 * potassium >= 53, "c7")
    m.addConstr(13 * vitamin_b1 + 23 * vitamin_b3 + 16 * vitamin_b2 >= 45, "c8")
    m.addConstr(13 * vitamin_b1 + 23 * vitamin_b3 + 9 * potassium >= 45, "c9")
    m.addConstr(21 * vitamin_b5 + 16 * vitamin_b2 + 9 * potassium >= 45, "c10")
    m.addConstr(21 * vitamin_b5 + 23 * vitamin_b3 + 16 * vitamin_b2 >= 45, "c11")
    m.addConstr(13 * vitamin_b1 + 23 * vitamin_b3 + 16 * vitamin_b2 >= 53, "c12")
    m.addConstr(13 * vitamin_b1 + 23 * vitamin_b3 + 9 * potassium >= 53, "c13")
    m.addConstr(21 * vitamin_b5 + 16 * vitamin_b2 + 9 * potassium >= 53, "c14")
    m.addConstr(21 * vitamin_b5 + 23 * vitamin_b3 + 16 * vitamin_b2 >= 53, "c15")
    m.addConstr(13 * vitamin_b1 + 23 * vitamin_b3 + 16 * vitamin_b2 >= 60, "c16")
    m.addConstr(13 * vitamin_b1 + 23 * vitamin_b3 + 9 * potassium >= 60, "c17")
    m.addConstr(21 * vitamin_b5 + 16 * vitamin_b2 + 9 * potassium >= 60, "c18")
    m.addConstr(21 * vitamin_b5 + 23 * vitamin_b3 + 16 * vitamin_b2 >= 60, "c19")
    m.addConstr(13 * vitamin_b1 + 23 * vitamin_b3 + 16 * vitamin_b2 >= 78, "c20")
    m.addConstr(13 * vitamin_b1 + 23 * vitamin_b3 + 9 * potassium >= 78, "c21")
    m.addConstr(21 * vitamin_b5 + 16 * vitamin_b2 + 9 * potassium >= 78, "c22")
    m.addConstr(21 * vitamin_b5 + 23 * vitamin_b3 + 16 * vitamin_b2 >= 78, "c23")
    m.addConstr(8 * vitamin_b1 - 3 * vitamin_b5 + 10 * vitamin_b3 >= 0, "c24")
    m.addConstr(21 * vitamin_b5 + 9 * potassium <= 275, "c25")
    m.addConstr(16 * vitamin_b2 + 9 * potassium <= 144, "c26")
    m.addConstr(13 * vitamin_b1 + 21 * vitamin_b5 + 9 * potassium <= 197, "c27")
    m.addConstr(13 * vitamin_b1 + 23 * vitamin_b3 + 9 * potassium <= 265, "c28")
    m.addConstr(13 * vitamin_b1 + 21 * vitamin_b5 + 23 * vitamin_b3 + 16 * vitamin_b2 + 9 * potassium <= 265, "c29")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
