
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="milligrams of vitamin B1", lb=-gurobi.GRB.INFINITY)
    x1 = model.addVar(name="milligrams of vitamin B5", lb=-gurobi.GRB.INFINITY)
    x2 = model.addVar(name="milligrams of vitamin B3", lb=-gurobi.GRB.INFINITY)
    x3 = model.addVar(name="milligrams of vitamin B2", lb=-gurobi.GRB.INFINITY)
    x4 = model.addVar(name="milligrams of potassium", lb=-gurobi.GRB.INFINITY)

    # Define the objective function
    model.setObjective(2*x0 + 3*x1 + 3*x2 + 5*x3 + 9*x4, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(13*x0 + 21*x1 >= 46)
    model.addConstr(23*x2 + 16*x3 >= 37)
    model.addConstr(21*x1 + 16*x3 >= 33)
    model.addConstr(13*x0 + 23*x2 >= 51)
    model.addConstr(21*x1 + 23*x2 >= 59)
    model.addConstr(16*x3 + 9*x4 >= 33)
    model.addConstr(13*x0 + 9*x4 >= 53)
    model.addConstr(13*x0 + 23*x2 + 16*x3 >= 45)
    model.addConstr(13*x0 + 23*x2 + 9*x4 >= 45)
    model.addConstr(21*x1 + 16*x3 + 9*x4 >= 45)
    model.addConstr(21*x1 + 23*x2 + 16*x3 >= 45)
    model.addConstr(13*x0 + 23*x2 + 16*x3 >= 53)
    model.addConstr(13*x0 + 23*x2 + 9*x4 >= 53)
    model.addConstr(21*x1 + 16*x3 + 9*x4 >= 53)
    model.addConstr(21*x1 + 23*x2 + 16*x3 >= 53)
    model.addConstr(13*x0 + 23*x2 + 16*x3 >= 60)
    model.addConstr(13*x0 + 23*x2 + 9*x4 >= 60)
    model.addConstr(21*x1 + 16*x3 + 9*x4 >= 60)
    model.addConstr(21*x1 + 23*x2 + 16*x3 >= 60)
    model.addConstr(13*x0 + 23*x2 + 16*x3 >= 78)
    model.addConstr(13*x0 + 23*x2 + 9*x4 >= 78)
    model.addConstr(21*x1 + 16*x3 + 9*x4 >= 78)
    model.addConstr(21*x1 + 23*x2 + 16*x3 >= 78)
    model.addConstr(8*x0 - 3*x1 + 10*x2 >= 0)
    model.addConstr(21*x1 + 9*x4 <= 275)
    model.addConstr(16*x3 + 9*x4 <= 144)
    model.addConstr(13*x0 + 21*x1 + 9*x4 <= 197)
    model.addConstr(13*x0 + 23*x2 + 9*x4 <= 265)
    model.addConstr(13*x0 + 21*x1 + 23*x2 + 16*x3 + 9*x4 <= 265)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print("Milligrams of vitamin B1: ", x0.varValue)
        print("Milligrams of vitamin B5: ", x1.varValue)
        print("Milligrams of vitamin B3: ", x2.varValue)
        print("Milligrams of vitamin B2: ", x3.varValue)
        print("Milligrams of potassium: ", x4.varValue)
        print("Objective function value: ", model.objVal)
    else:
        print("No optimal solution found.")

solve_optimization_problem()
