
import gurobipy as gp

# Create a new model
m = gp.Model("minimize_staff_cost")

# Create variables
laura_hours = m.addVar(lb=0, name="laura_hours")
dale_hours = m.addVar(lb=0, name="dale_hours")
hank_hours = m.addVar(lb=0, name="hank_hours")
george_hours = m.addVar(lb=0, name="george_hours")
paul_hours = m.addVar(lb=0, name="paul_hours")
mary_hours = m.addVar(lb=0, name="mary_hours")
jean_hours = m.addVar(lb=0, name="jean_hours")

# Set objective function
m.setObjective(1.04 * laura_hours + 7.65 * dale_hours + 6.09 * hank_hours + 3.37 * george_hours + 7.17 * paul_hours + 2.42 * mary_hours + 2.68 * jean_hours, gp.GRB.MINIMIZE)

# Resource data
resources = {
    'r0': {'description': 'organization score', 'upper_bound': 439, 'x0': 8.22, 'x1': 6.55, 'x2': 1.4, 'x3': 7.69, 'x4': 11.26, 'x5': 4.18, 'x6': 11.57},
    'r1': {'description': 'work quality rating', 'upper_bound': 442, 'x0': 9.07, 'x1': 12.68, 'x2': 12.78, 'x3': 1.74, 'x4': 9.37, 'x5': 7.46, 'x6': 9.53},
    'r2': {'description': 'paperwork competence rating', 'upper_bound': 359, 'x0': 2.82, 'x1': 8.72, 'x2': 3.79, 'x3': 8.52, 'x4': 0.35, 'x5': 7.85, 'x6': 8.83},
    'r3': {'description': 'dollar cost per hour', 'upper_bound': 420, 'x0': 10.7, 'x1': 7.57, 'x2': 6.98, 'x3': 0.12, 'x4': 1.05, 'x5': 12.01, 'x6': 2.85},
    'r4': {'description': 'computer competence rating', 'upper_bound': 447, 'x0': 12.33, 'x1': 9.54, 'x2': 7.87, 'x3': 4.1, 'x4': 7.53, 'x5': 8.43, 'x6': 7.98}
}
variables = [laura_hours, dale_hours, hank_hours, george_hours, paul_hours, mary_hours, jean_hours]

# Add constraints
for r_key, r_data in resources.items():
    for constraint in INPUT.split('\n'):
        if r_data['description'] in constraint:
            parts = constraint.split()
            involved_vars = []
            coeffs = []
            sense = None
            rhs = None

            for i, var in enumerate(variables):
                if f"hours worked by {var.VarName.split('_')[0].capitalize()}" in constraint:
                    involved_vars.append(var)
                    try:
                        coeffs.append(float(parts[parts.index(f"by") + i + 2]))
                    except (ValueError, IndexError):
                        coeffs.append(1.0)  # Default coefficient is 1

            if "at a minimum" in constraint or "no less than" in constraint or "as much or more than" in constraint or "or more" in constraint or "greater than or equal to" in constraint or "at least" in constraint or "has to be as much or more than" in constraint or "has to be greater than or equal to" in constraint or "must be greater than or equal to" in constraint:
                sense = gp.GRB.GREATER_EQUAL
                rhs = float(parts[parts.index("be") + 1])
            elif "at maximum" in constraint or "no more than" in constraint or "as much or less than" in constraint or "or less" in constraint or "less than or equal to" in constraint or "at most" in constraint or "has to be equal to or less than" in constraint or "has to be  no more than" in constraint or "must be less than or equal to" in constraint:
                sense = gp.GRB.LESS_EQUAL
                rhs = float(parts[parts.index("be") + 1])
            elif "equal to or greater than" in constraint:
                sense = gp.GRB.GREATER_EQUAL
                rhs = float(parts[parts.index("than") + 1])
            elif "equal to or less than" in constraint:
                sense = gp.GRB.LESS_EQUAL
                rhs = float(parts[parts.index("than") + 1])

            if sense is not None and rhs is not None:
                m.addConstr(gp.quicksum(coeffs[i] * involved_vars[i] * r_data[f'x{i}'] for i in range(len(involved_vars))) , sense, rhs)

m.addConstr(2 * laura_hours - 8 * jean_hours >= 0)

# Optimize model
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

