
import gurobi as gp

# Create a new model
m = gp.Model("optimization")

# Define variables
L = m.addVar(lb=0, name="L")
D = m.addVar(lb=0, name="D")
H = m.addVar(lb=0, name="H")
G = m.addVar(lb=0, name="G")
P = m.addVar(lb=0, name="P")
M = m.addVar(lb=0, name="M")
J = m.addVar(lb=0, name="J")

# Objective function
m.setObjective(1.04*L + 7.65*D + 6.09*H + 3.37*G + 7.17*P + 2.42*M + 2.68*J, gp.GRB.MINIMIZE)

# Add constraints
# Organization Score Constraints
m.addConstr(8.22*L + 6.55*D + 1.4*H + 7.69*G + 11.26*P + 4.18*M + 11.57*J <= 439)
m.addConstr(1.4*G + 4.18*M >= 62)
m.addConstr(1.4*H + 7.69*G >= 35)
m.addConstr(1.4*H + 11.26*P >= 55)
m.addConstr(7.69*G + 11.57*J >= 57)
m.addConstr(6.55*D + 11.57*J >= 35)
m.addConstr(8.22*L + 11.26*P >= 34)
m.addConstr(4.18*M + 11.57*J >= 22)
m.addConstr(7.69*G + 11.26*P >= 43)
m.addConstr(8.22*L + 7.69*G >= 35)
m.addConstr(6.55*D + 7.69*G >= 29)
m.addConstr(6.55*D + 1.4*H >= 37)
m.addConstr(8.22*L + 6.55*D >= 38)
m.addConstr(11.26*P + 11.57*J >= 47)
m.addConstr(1.4*H + 11.26*P + 11.57*J >= 43)
m.addConstr(8.22*L + 6.55*D + 1.4*H + 7.69*G + 11.26*P + 4.18*M + 11.57*J >= 43)

# Work Quality Rating Constraints
m.addConstr(9.07*D + 7.46*M >= 43)
m.addConstr(12.68*D + 9.53*J >= 46)
m.addConstr(7.46*M + 9.53*J >= 62)
m.addConstr(9.37*P + 7.46*M >= 44)
m.addConstr(9.07*D + 9.37*P >= 34)
m.addConstr(12.78*H + 7.46*M >= 44)
m.addConstr(9.07*L + 12.68*D >= 59)
m.addConstr(1.74*G + 7.46*M + 9.53*J >= 46)

# ... add all constraints similarly

# Optimize
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("L: ", L.varValue)
    print("D: ", D.varValue)
    print("H: ", H.varValue)
    print("G: ", G.varValue)
    print("P: ", P.varValue)
    print("M: ", M.varValue)
    print("J: ", J.varValue)
else:
    print("No solution found")
