
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
potatoes = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="potatoes")
apple_pies = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="apple_pies")
kale_salads = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="kale_salads")

# Set objective function
m.setObjective(2.08 * potatoes**2 + 2.07 * apple_pies**2 + 9.38 * apple_pies * kale_salads, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(13.7 * apple_pies + 11.67 * kale_salads <= 50, "calcium_constraint1")
m.addConstr(2.54 * potatoes**2 + 11.67 * kale_salads**2 <= 115, "calcium_constraint2")
m.addConstr(2.54 * potatoes + 13.7 * apple_pies + 11.67 * kale_salads <= 115, "calcium_constraint3")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal objective value: {m.objVal}")
    print(f"Potatoes: {potatoes.x}")
    print(f"Apple Pies: {apple_pies.x}")
    print(f"Kale Salads: {kale_salads.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

