
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define the variables
potatoes = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.CONTINUOUS, name="potatoes")
apple_pies = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.INTEGER, name="apple_pies")
kale_salads = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.CONTINUOUS, name="kale_salads")

# Define the objective function
m.setObjective(2.08 * potatoes**2 + 2.07 * apple_pies**2 + 9.38 * apple_pies * kale_salads, GRB.MAXIMIZE)

# Add constraints
m.addConstr(2.54*potatoes + 13.7*apple_pies + 11.67*kale_salads <= 126, name="Total_Calcium_Constraint")
m.addConstr(13.7*apple_pies + 11.67*kale_salads <= 50, name="Apple_Pies_and_Kale_Salads_Calcium_Constraint")
m.addConstr((2.54*potatoes)**2 + (11.67*kale_salads)**2 <= 115, name="Potatoes_and_Kale_Salads_Squared_Calcium_Constraint")
m.addConstr(2.54*potatoes + 13.7*apple_pies + 11.67*kale_salads <= 115, name="Total_Calcium_Constraint_2")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Potatoes: {potatoes.x}")
    print(f"Apple Pies: {apple_pies.x}")
    print(f"Kale Salads: {kale_salads.x}")
else:
    print("No optimal solution found")
