
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    potatoes = model.addVar(lb=0, name="potatoes", vtype=gurobi.GRB.CONTINUOUS)
    apple_pies = model.addVar(lb=0, name="apple_pies", vtype=gurobi.GRB.INTEGER)
    kale_salads = model.addVar(lb=0, name="kale_salads", vtype=gurobi.GRB.CONTINUOUS)

    # Define the objective function
    model.setObjective(2.08 * potatoes**2 + 2.07 * apple_pies**2 + 9.38 * apple_pies * kale_salads, gurobi.GRB.MAXIMIZE)

    # Define the constraints
    model.addConstr(13.7 * apple_pies + 11.67 * kale_salads <= 50, name="calcium_from_apple_pies_and_kale_salads")
    model.addConstr(2.54 * potatoes**2 + 11.67 * kale_salads**2 <= 115, name="calcium_from_potatoes_squared_and_kale_salads_squared")
    model.addConstr(2.54 * potatoes + 13.7 * apple_pies + 11.67 * kale_salads <= 115, name="total_calcium")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Potatoes: {potatoes.varValue}")
        print(f"Apple Pies: {apple_pies.varValue}")
        print(f"Kale Salads: {kale_salads.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
