
import gurobipy as gp

# Create a new model
m = gp.Model("resource_allocation")

# Create variables
jean_hours = m.addVar(lb=0, name="jean_hours")
mary_hours = m.addVar(lb=0, name="mary_hours")

# Set objective function
m.setObjective(5.11 * jean_hours + 6.35 * mary_hours, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(5 * jean_hours + 1 * mary_hours >= 19, "organization_score_min")
m.addConstr(12 * jean_hours + 4 * mary_hours >= 18, "dollar_cost_min")
m.addConstr(10 * jean_hours + 7 * mary_hours >= 21, "computer_competence_min")
m.addConstr(12 * jean_hours + 14 * mary_hours >= 10, "paperwork_competence_min")
m.addConstr(8 * jean_hours - 1 * mary_hours >= 0, "custom_constraint")

m.addConstr(5 * jean_hours + 1 * mary_hours <= 34, "organization_score_max")
m.addConstr(12 * jean_hours + 4 * mary_hours <= 31, "dollar_cost_max")
m.addConstr(10 * jean_hours + 7 * mary_hours <= 52, "computer_competence_max")
m.addConstr(12 * jean_hours + 14 * mary_hours <= 42, "paperwork_competence_max")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Optimal objective: %g' % m.objVal)
    print('Jean hours:', jean_hours.x)
    print('Mary hours:', mary_hours.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('Model is infeasible')
else:
    print('Optimization ended with status %d' % m.status)

