
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(name="hours_worked_by_Jean", lb=0)  # Hours worked by Jean
x1 = m.addVar(name="hours_worked_by_Mary", lb=0)  # Hours worked by Mary

# Set the objective function
m.setObjective(5.11*x0 + 6.35*x1, GRB.MINIMIZE)

# Add constraints
m.addConstr(5*x0 + 1*x1 >= 19, name="organization_score_min")
m.addConstr(5*x0 + 1*x1 <= 34, name="organization_score_max")
m.addConstr(12*x0 + 4*x1 >= 18, name="dollar_cost_per_hour_min")
m.addConstr(12*x0 + 4*x1 <= 31, name="dollar_cost_per_hour_max")
m.addConstr(10*x0 + 7*x1 >= 21, name="computer_competence_rating_min")
m.addConstr(10*x0 + 7*x1 <= 52, name="computer_competence_rating_max")
m.addConstr(12*x0 + 14*x1 >= 10, name="paperwork_competence_rating_min")
m.addConstr(12*x0 + 14*x1 <= 42, name="paperwork_competence_rating_max")
m.addConstr(8*x0 - x1 >= 0, name="additional_constraint")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hours worked by Jean: {x0.x}")
    print(f"Hours worked by Mary: {x1.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
