
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    jean_hours = model.addVar(name="jean_hours", lb=0)  # Assuming hours cannot be negative
    mary_hours = model.addVar(name="mary_hours", lb=0)  # Assuming hours cannot be negative

    # Define the objective function
    model.setObjective(5.11 * jean_hours + 6.35 * mary_hours, gurobi.GRB.MINIMIZE)

    # Define the constraints
    model.addConstr(5 * jean_hours + 1 * mary_hours >= 19, name="org_score_min")
    model.addConstr(12 * jean_hours + 4 * mary_hours >= 18, name="dollar_cost_min")
    model.addConstr(10 * jean_hours + 7 * mary_hours >= 21, name="comp_comp_min")
    model.addConstr(12 * jean_hours + 14 * mary_hours >= 10, name="paperwork_comp_min")
    model.addConstr(8 * jean_hours - 1 * mary_hours >= 0, name="jean_mary_hours_ratio")
    model.addConstr(5 * jean_hours + 1 * mary_hours <= 34, name="org_score_max")
    model.addConstr(12 * jean_hours + 4 * mary_hours <= 31, name="dollar_cost_max")
    model.addConstr(10 * jean_hours + 7 * mary_hours <= 52, name="comp_comp_max")
    model.addConstr(12 * jean_hours + 14 * mary_hours <= 42, name="paperwork_comp_max")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Hours worked by Jean: {jean_hours.varValue}")
        print(f"Hours worked by Mary: {mary_hours.varValue}")
        print(f"Objective Function Value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
