
from gurobipy import Model, GRB

# Create a new model
m = Model("resource_allocation")

# Create variables
pen_testers = m.addVar(vtype=GRB.INTEGER, name="pen_testers")
system_administrators = m.addVar(vtype=GRB.INTEGER, name="system_administrators")
automatic_alerts = m.addVar(vtype=GRB.INTEGER, name="automatic_alerts")
network_administrators = m.addVar(vtype=GRB.INTEGER, name="network_administrators")

# Set objective function
m.setObjective(9 * pen_testers + 4 * system_administrators + 3 * automatic_alerts + 7 * network_administrators, GRB.MINIMIZE)

# Add constraints
m.addConstr(27 * pen_testers + 21 * system_administrators + 31 * automatic_alerts + 28 * network_administrators <= 229, "Network Latency")
m.addConstr(5 * pen_testers + 17 * system_administrators + 29 * automatic_alerts + 31 * network_administrators <= 781, "Dollar Cost")
m.addConstr(24 * pen_testers + 22 * system_administrators + 11 * automatic_alerts + 7 * network_administrators <= 497, "Network Integrity Impact")
m.addConstr(21 * pen_testers + 31 * system_administrators + 31 * automatic_alerts + 12 * network_administrators <= 580, "Data Accessibility Impact")

m.addConstr(21 * system_administrators + 28 * network_administrators >= 34, "Min Latency sysadmin & netadmin")
m.addConstr(27 * pen_testers + 31 * automatic_alerts >= 43, "Min Latency pentest & alerts")
m.addConstr(27 * pen_testers + 21 * system_administrators + 31 * automatic_alerts + 28 * network_administrators >= 43, "Min Latency Total")

m.addConstr(5 * pen_testers + 17 * system_administrators >= 160, "Min Cost pentest & sysadmin")
m.addConstr(29 * automatic_alerts + 31 * network_administrators >= 70, "Min Cost alerts & netadmin")
m.addConstr(17 * system_administrators + 31 * network_administrators >= 165, "Min Cost sysadmin & netadmin")
m.addConstr(5 * pen_testers + 29 * automatic_alerts >= 80, "Min Cost pentest & alerts")
m.addConstr(17 * system_administrators + 29 * automatic_alerts + 31 * network_administrators >= 178, "Min Cost sysadmin & alerts & netadmin")
m.addConstr(5 * pen_testers + 17 * system_administrators + 29 * automatic_alerts + 31 * network_administrators >= 178, "Min Cost Total")

m.addConstr(24 * pen_testers + 11 * automatic_alerts >= 107, "Min Network Integrity pentest & alerts")
m.addConstr(24 * pen_testers + 7 * network_administrators >= 75, "Min Network Integrity pentest & netadmin")
m.addConstr(22 * system_administrators + 11 * automatic_alerts >= 124, "Min Network Integrity sysadmin & alerts")
m.addConstr(24 * pen_testers + 22 * system_administrators >= 87, "Min Network Integrity pentest & sysadmin")
m.addConstr(11 * automatic_alerts + 7 * network_administrators >= 60, "Min Network Integrity alerts & netadmin")
m.addConstr(24 * pen_testers + 22 * system_administrators + 11 * automatic_alerts + 7 * network_administrators >= 60, "Min Network Integrity Total")

m.addConstr(21 * pen_testers + 31 * system_administrators >= 123, "Min Data Accessibility pentest & sysadmin")
m.addConstr(21 * pen_testers + 31 * automatic_alerts >= 77, "Min Data Accessibility pentest & alerts")
m.addConstr(31 * system_administrators + 31 * automatic_alerts >= 126, "Min Data Accessibility sysadmin & alerts")
m.addConstr(31 * automatic_alerts + 12 * network_administrators >= 96, "Min Data Accessibility alerts & netadmin")
m.addConstr(21 * pen_testers + 12 * network_administrators >= 74, "Min Data Accessibility pentest & netadmin")
m.addConstr(21 * pen_testers + 31 * system_administrators + 31 * automatic_alerts + 12 * network_administrators >= 74, "Min Data Accessibility Total")


m.addConstr(4 * pen_testers - 7 * system_administrators >= 0, "Constraint 1")
m.addConstr(-1 * pen_testers + 4 * network_administrators >= 0, "Constraint 2")

m.addConstr(17 * system_administrators + 29 * automatic_alerts <= 681, "Max Cost sysadmin & alerts")
m.addConstr(5 * pen_testers + 29 * automatic_alerts <= 346, "Max Cost pentest & alerts")
m.addConstr(5 * pen_testers + 17 * system_administrators <= 316, "Max Cost pentest & sysadmin")
m.addConstr(29 * automatic_alerts + 31 * network_administrators <= 309, "Max Cost alerts & netadmin")
m.addConstr(5 * pen_testers + 17 * system_administrators + 31 * network_administrators <= 775, "Max Cost pentest & sysadmin & netadmin")

m.addConstr(11 * automatic_alerts + 7 * network_administrators <= 411, "Max Network Integrity alerts & netadmin")

m.addConstr(31 * automatic_alerts + 12 * network_administrators <= 277, "Max Data Accessibility alerts & netadmin")
m.addConstr(31 * system_administrators + 12 * network_administrators <= 166, "Max Data Accessibility sysadmin & netadmin")
m.addConstr(31 * system_administrators + 31 * automatic_alerts <= 525, "Max Data Accessibility sysadmin & alerts")
m.addConstr(21 * pen_testers + 31 * system_administrators <= 166, "Max Data Accessibility pentest & sysadmin")
m.addConstr(21 * pen_testers + 31 * automatic_alerts <= 484, "Max Data Accessibility pentest & alerts")
m.addConstr(31 * system_administrators + 31 * automatic_alerts + 12 * network_administrators <= 439, "Max Data Accessibility sysadmin & alerts & netadmin")
m.addConstr(21 * pen_testers + 31 * system_administrators + 12 * network_administrators <= 317, "Max Data Accessibility pentest & sysadmin & netadmin")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

