
from gurobipy import Model, GRB

# Create a new model
m = Model("resource_allocation")

# Create variables
bobby_hours = m.addVar(vtype=GRB.INTEGER, name="bobby_hours")
paul_hours = m.addVar(vtype=GRB.CONTINUOUS, name="paul_hours")
hank_hours = m.addVar(vtype=GRB.CONTINUOUS, name="hank_hours")

# Set objective function
m.setObjective(8*bobby_hours**2 + 6*bobby_hours*paul_hours + 6*paul_hours**2 + 3*paul_hours*hank_hours + bobby_hours + 9*paul_hours + hank_hours, GRB.MINIMIZE)

# Add constraints
m.addConstr(5*bobby_hours + 16*paul_hours + 15*hank_hours >= 55, "c0") # Total organization score >= 55
m.addConstr(5*bobby_hours**2 + 16*paul_hours**2 >= 55, "c1") # Combined organization score (squared) >= 55
m.addConstr(18*bobby_hours + 15*paul_hours >= 22, "c2") # Combined productivity rating >= 22
m.addConstr(18*bobby_hours + 15*paul_hours + 12*hank_hours >= 22, "c3") # Total productivity rating >= 22
m.addConstr(18*bobby_hours**2 + 12*hank_hours**2 >= 50, "c4") # Combined productivity rating (squared) >= 50
m.addConstr(13*paul_hours + 5*hank_hours >= 25, "c5") # Combined likelihood to quit >= 25
m.addConstr(11*bobby_hours + 13*paul_hours >= 27, "c6") # Combined likelihood to quit >= 27
m.addConstr(11*bobby_hours**2 + 13*paul_hours**2 + 5*hank_hours**2 >= 27, "c7") # Combined likelihood to quit (squared) >= 27
m.addConstr(11*bobby_hours + 13*paul_hours + 5*hank_hours >= 27, "c8") # Total likelihood to quit >= 27
m.addConstr(13*bobby_hours + 16*hank_hours >= 48, "c9") # Combined dollar cost >= 48
m.addConstr(6*paul_hours + 16*hank_hours >= 57, "c10") # Combined dollar cost >= 57
m.addConstr(13*bobby_hours**2 + 6*paul_hours**2 + 16*hank_hours**2 >= 88, "c11") # Combined dollar cost (squared) >= 88
m.addConstr(13*bobby_hours + 6*paul_hours + 16*hank_hours >= 88, "c12") # Total dollar cost >= 88

m.addConstr(paul_hours - 4*hank_hours >= 0, "c13")
m.addConstr(18*bobby_hours + 12*hank_hours <= 107, "c14")
m.addConstr(18*bobby_hours + 15*paul_hours + 12*hank_hours <= 102, "c15")
m.addConstr(13*paul_hours**2 + 5*hank_hours**2 <= 47, "c16")
m.addConstr(11*bobby_hours + 5*hank_hours <= 59, "c17")
m.addConstr(11*bobby_hours + 13*paul_hours <= 34, "c18")
m.addConstr(11*bobby_hours + 13*paul_hours + 5*hank_hours <= 59, "c19")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('Bobby Hours:', bobby_hours.x)
    print('Paul Hours:', paul_hours.x)
    print('Hank Hours:', hank_hours.x)
elif m.status == GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)
