
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables
B = m.addVar(vtype=GRB.INTEGER, name="hours_worked_by_Bobby")
P = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_Paul")
H = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_Hank")

# Objective function
m.setObjective(8*B**2 + 6*B*P + 6*P**2 + 3*P*H + B + 9*P + H, GRB.MINIMIZE)

# Constraints
m.addConstr(B >= 0)  # Implicit constraint for hours worked
m.addConstr(P >= 0)
m.addConstr(H >= 0)

# Organization score constraints
m.addConstr(5*B <= 283)
m.addConstr(16*P <= 195)
m.addConstr(15*H <= 92)

# Productivity rating constraints
m.addConstr(18*B <= 195)
m.addConstr(15*P <= 195)
m.addConstr(12*H <= 195)

# Likelihood to quit index constraints
m.addConstr(11*B <= 92)
m.addConstr(13*P <= 92)
m.addConstr(5*H <= 92)

# Dollar cost per hour constraints
m.addConstr(13*B <= 265)
m.addConstr(6*P <= 265)
m.addConstr(16*H <= 265)

# Combined organization score constraints
m.addConstr(B**2 + P**2 >= 55)
m.addConstr(B + P + H >= 55)

# Combined productivity rating constraints
m.addConstr(B**2 + H**2 >= 50)
m.addConstr(B + P >= 22)
m.addConstr(B + P + H >= 22)

# Combined likelihood to quit index constraints
m.addConstr(P + H >= 25)
m.addConstr(B + P >= 27)
m.addConstr(B**2 + P**2 + H**2 >= 27)
m.addConstr(B + P + H >= 27)

# Combined dollar cost per hour constraints
m.addConstr(13*B + 16*H >= 48)
m.addConstr(6*P + 16*H >= 57)
m.addConstr(B**2 + P**2 + H**2 >= 88)
m.addConstr(B + P + H >= 88)

# Additional linear constraints
m.addConstr(P - 4*H >= 0)

# Maximum productivity rating constraints
m.addConstr(18*B + 12*H <= 107)
m.addConstr(18*B + 15*P + 12*H <= 102)

# Maximum likelihood to quit index constraints
m.addConstr(13**2*P + 5**2*H <= 47)
m.addConstr(11*B + 5*H <= 59)
m.addConstr(11*B + 13*P <= 34)
m.addConstr(11*B + 13*P + 5*H <= 59)

# Optimize the model
m.optimize()

