
import gurobi as gp

# Define the model
m = gp.Model("optimization_problem")

# Define the variables
B = m.addVar(name="Bobby", vtype=gp.GRB.INTEGER)  # Integer hours for Bobby
P = m.addVar(name="Paul")  # Continuous hours for Paul
H = m.addVar(name="Hank")  # Continuous hours for Hank

# Objective function
m.setObjective(8*B**2 + 6*B*P + 6*P**2 + 3*P*H + B + 9*P + H, gp.GRB.MINIMIZE)

# Constraints
m.addConstr(B == 5, name="Bobby_org")
m.addConstr(18*B == 18, name="Bobby_prod") # This constraint is always true and can be removed
m.addConstr(11*B == 11, name="Bobby_quit")
m.addConstr(13*B == 13, name="Bobby_cost")

m.addConstr(P == 16, name="Paul_org")
m.addConstr(15*P == 15, name="Paul_prod") # This constraint is always true and can be removed
m.addConstr(13*P == 13, name="Paul_quit")
m.addConstr(6*P == 6, name="Paul_cost")

m.addConstr(H == 15, name="Hank_org")
m.addConstr(12*H == 12, name="Hank_prod") # This constraint is always true and can be removed
m.addConstr(5*H == 5, name="Hank_quit")
m.addConstr(16*H == 16, name="Hank_cost")

m.addConstr(B**2 + P**2 >= 55, name="org_score")
m.addConstr(B + P + H >= 55, name="total_org_score")

m.addConstr(B**2 + H**2 >= 50, name="prod_rating_BH")
m.addConstr(B + P >= 22, name="prod_rating_BP")
m.addConstr(B + P + H >= 22, name="prod_rating_BPH")

m.addConstr(13*P + 5*H >= 25, name="quit_index_PH")
m.addConstr(11*B + 13*P >= 27, name="quit_index_BP")
m.addConstr(11**2*B**2 + 13**2*P**2 + 5**2*H**2 >= 27, name="quit_index_BPH_squared")
m.addConstr(11*B + 13*P + 5*H >= 27, name="quit_index_BPH")

m.addConstr(13*B + 16*H >= 48, name="cost_BH")
m.addConstr(6*P + 16*H >= 57, name="cost_PH")
m.addConstr(13**2*B**2 + 6**2*P**2 + 16**2*H**2 >= 88, name="cost_BPH_squared")
m.addConstr(13*B + 6*P + 16*H >= 88, name="cost_BPH")

m.addConstr(P - 4*H >= 0, name="Paul_Hank")

m.addConstr(18*B + 12*H <= 107, name="prod_rating_BH_max")
m.addConstr(18*B + 15*P + 12*H <= 102, name="prod_rating_BPH_max")

m.addConstr(13**2*P**2 + 5**2*H**2 <= 47, name="quit_index_PH_max")
m.addConstr(11*B + 5*H <= 59, name="quit_index_BH_max")
m.addConstr(11*B + 13*P <= 34, name="quit_index_BP_max")
m.addConstr(11*B + 13*P + 5*H <= 59, name="quit_index_BPH_max")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Bobby hours: ", B.varValue)
    print("Paul hours: ", P.varValue)
    print("Hank hours: ", H.varValue)
else:
    print("The model is infeasible")
