
import gurobipy as gp

# Create a new model
model = gp.Model("Work_Optimization")

# Create variables
mary = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="mary")
hank = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="hank")
john = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="john")
jean = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="jean")
peggy = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="peggy")
bill = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bill")
dale = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="dale")
ringo = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="ringo")

# Set objective function
obj = 6*mary*mary + 3*mary*hank + 7*mary*john + mary*jean + 3*mary*peggy + mary*dale + 7*mary*ringo + 4*hank*hank + 7*hank*john + 2*hank*jean + 6*hank*peggy + 3*hank*bill + 8*hank*dale + 9*hank*ringo + john*john + 5*john*jean + 7*john*peggy + 9*john*bill + 6*john*dale + 6*john*ringo + 2*jean*jean + 7*jean*bill + 7*jean*dale + 7*peggy*peggy + 9*peggy*dale + 2*peggy*ringo + 9*bill*bill + 7*bill*dale + 4*dale*dale + 4*dale*ringo + 8*john + 6*jean + 9*bill + 2*ringo
model.setObjective(obj, gp.GRB.MAXIMIZE)

# Resource data
resources = {'r0': {'description': 'organization score', 'upper_bound': 501, 'mary': 5, 'hank': 6, 'john': 8, 'jean': 9, 'peggy': 9, 'bill': 4, 'dale': 1, 'ringo': 11}, 
            'r1': {'description': 'productivity rating', 'upper_bound': 128, 'mary': 2, 'hank': 4, 'john': 10, 'jean': 3, 'peggy': 6, 'bill': 7, 'dale': 4, 'ringo': 1}, 
            'r2': {'description': 'computer competence rating', 'upper_bound': 193, 'mary': 2, 'hank': 5, 'john': 9, 'jean': 2, 'peggy': 2, 'bill': 2, 'dale': 8, 'ringo': 9}, 
            'r3': {'description': 'paperwork competence rating', 'upper_bound': 295, 'mary': 11, 'hank': 4, 'john': 2, 'jean': 10, 'peggy': 9, 'bill': 5, 'dale': 7, 'ringo': 5}}
variables = {'mary': mary, 'hank': hank, 'john': john, 'jean': jean, 'peggy': peggy, 'bill': bill, 'dale': dale, 'ringo': ringo}

# Add resource constraints
for r_key, r_data in resources.items():
    model.addConstr(gp.quicksum(r_data[v_key] * variables[v_key] for v_key in variables) <= r_data['upper_bound'], name=f"{r_data['description']}_constraint")


# Add other constraints from the input
model.addConstr(5*mary + 9*peggy >= 23, "c1")
model.addConstr(8*john + 4*bill >= 43, "c2")
model.addConstr(8*john + dale >= 36, "c3")
model.addConstr(5*mary + dale >= 21, "c4")
model.addConstr(5*mary + 9*jean >= 52, "c5")
model.addConstr(6*hank + 9*peggy >= 36, "c6")
model.addConstr(9*peggy + dale >= 59, "c7")
model.addConstr(6*hank + 11*ringo >= 24, "c8")
model.addConstr(9*jean + 9*peggy >= 49, "c9")
model.addConstr(8*john + 9*jean >= 25, "c10")
model.addConstr(5*mary + 11*ringo >= 60, "c11")
model.addConstr(9*peggy + 11*ringo >= 44, "c12")
model.addConstr(9*peggy + 4*bill >= 60, "c13")
model.addConstr(5*mary + 8*john + 11*ringo >= 41, "c14")
model.addConstr(6*hank*hank + 4*bill*bill + 11*ringo*ringo >= 41, "c15")
model.addConstr(6*hank + 9*jean + 11*ringo >= 41, "c16")
model.addConstr(5*mary + 9*jean + 11*ringo >= 41, "c17")
model.addConstr(9*jean + 9*peggy + 4*bill >= 41, "c18")
model.addConstr(5*mary*mary + 8*john*john + 11*ringo*ringo >= 54, "c19")
model.addConstr(6*hank + 4*bill + 11*ringo >= 54, "c20")
model.addConstr(6*hank + 9*jean + 11*ringo >= 54, "c21")
model.addConstr(5*mary + 9*jean + 11*ringo >= 54, "c22")
model.addConstr(9*jean + 9*peggy + 4*bill >= 54, "c23")
model.addConstr(5*mary + 8*john + 11*ringo >= 37, "c24")
model.addConstr(6*hank + 4*bill + 11*ringo >= 37, "c25")
model.addConstr(6*hank*hank + 9*jean*jean + 11*ringo*ringo >= 37, "c26")
model.addConstr(5*mary*mary + 9*jean*jean + 11*ringo*ringo >= 37, "c27")
model.addConstr(9*jean*jean + 9*peggy*peggy + 4*bill*bill >= 37, "c28")
model.addConstr(5*mary*mary + 8*john*john + 11*ringo*ringo >= 37, "c29")
model.addConstr(6*hank + 4*bill + 11*ringo >= 37, "c30")
model.addConstr(6*hank + 9*jean + 11*ringo >= 37, "c31")
model.addConstr(5*mary*mary + 9*jean*jean + 11*ringo*ringo >= 37, "c32")
model.addConstr(9*jean + 9*peggy + 4*bill >= 37, "c33")
model.addConstr(5*mary*mary + 8*john*john + 11*ringo*ringo >= 38, "c34")
model.addConstr(6*hank + 4*bill + 11*ringo >= 38, "c35")
model.addConstr(6*hank + 9*jean + 11*ringo >= 38, "c36")
model.addConstr(5*mary + 9*jean + 11*ringo >= 38, "c37")
model.addConstr(9*jean*jean + 9*peggy*peggy + 4*bill*bill >= 38, "c38")


# ... (rest of the constraints)

# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    for v in model.getVars():
        print('%s %g' % (v.varName, v.x))
elif model.status == gp.GRB.INFEASIBLE:
    print('Optimization was stopped with status %d' % model.status)
    # Compute IIS
    model.computeIIS()
    for c in model.getConstrs():
        if c.IISConstr:
            print('%s' % c.constrName)
