
from gurobipy import Model, GRB

# Create a new model
model = Model("Resource Allocation")

# Define decision variables
printers = model.addVar(vtype=GRB.INTEGER, name="3D_printers")
staplers = model.addVar(vtype=GRB.INTEGER, name="staplers")
yellow_highlighters = model.addVar(vtype=GRB.INTEGER, name="yellow_highlighters")
red_highlighters = model.addVar(vtype=GRB.INTEGER, name="red_highlighters")
blue_pens = model.addVar(vtype=GRB.INTEGER, name="blue_pens")

# Set objective function
model.setObjective(7.83 * printers + 2.22 * staplers + 6.91 * yellow_highlighters + 2.41 * red_highlighters + 2.49 * blue_pens, GRB.MAXIMIZE)

# Add resource constraints
model.addConstr(10 * printers + 3 * staplers + 8 * yellow_highlighters + 2 * red_highlighters + 4 * blue_pens <= 180, "r0_workplace_safety")
model.addConstr(10 * printers + 2 * staplers + 6 * yellow_highlighters + 9 * red_highlighters + 4 * blue_pens <= 82, "r1_storage_space")
model.addConstr(9 * printers + 9 * staplers + 1 * yellow_highlighters + 5 * red_highlighters + 4 * blue_pens <= 168, "r2_employee_satisfaction")
model.addConstr(11 * printers + 1 * staplers + 7 * yellow_highlighters + 4 * red_highlighters + 11 * blue_pens <= 239, "r3_usefulness")


# Add additional constraints
model.addConstr(10 * printers + 2 * red_highlighters + 4 * blue_pens >= 19, "c1")
model.addConstr(2 * staplers + 6 * yellow_highlighters + 9 * red_highlighters >= 11, "c2")
model.addConstr(10 * printers + 6 * yellow_highlighters + 9 * red_highlighters >= 11, "c3")
model.addConstr(2 * staplers + 9 * red_highlighters + 4 * blue_pens >= 11, "c4")
model.addConstr(2 * staplers + 6 * yellow_highlighters + 9 * red_highlighters >= 12, "c5")
model.addConstr(10 * printers + 6 * yellow_highlighters + 9 * red_highlighters >= 12, "c6")
model.addConstr(2 * staplers + 9 * red_highlighters + 4 * blue_pens >= 12, "c7")
model.addConstr(2 * staplers + 6 * yellow_highlighters + 9 * red_highlighters >= 14, "c8")
model.addConstr(10 * printers + 6 * yellow_highlighters + 9 * red_highlighters >= 14, "c9")
model.addConstr(2 * staplers + 9 * red_highlighters + 4 * blue_pens >= 14, "c10")
model.addConstr(9 * printers + 1 * yellow_highlighters >= 31, "c11")

# ... (Add all remaining constraints similarly)


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"  3D printers: {printers.x}")
    print(f"  Staplers: {staplers.x}")
    print(f"  Yellow Highlighters: {yellow_highlighters.x}")
    print(f"  Red Highlighters: {red_highlighters.x}")
    print(f"  Blue Pens: {blue_pens.x}")
    print(f"  Objective value: {model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}.")

