
import gurobi as gp

# Define the model
m = gp.Model("optimization_problem")

# Define the variables
x0 = m.addVar(name="3D_printers", vtype=gp.GRB.INTEGER)  # 3D printers
x1 = m.addVar(name="staplers", vtype=gp.GRB.INTEGER)    # staplers
x2 = m.addVar(name="yellow_highlighters", vtype=gp.GRB.INTEGER)  # yellow highlighters
x3 = m.addVar(name="red_highlighters", vtype=gp.GRB.INTEGER)      # red highlighters
x4 = m.addVar(name="blue_pens", vtype=gp.GRB.INTEGER)            # blue pens

# Objective function
m.setObjective(7.83 * x0 + 2.22 * x1 + 6.91 * x2 + 2.41 * x3 + 2.49 * x4, gp.GRB.MAXIMIZE)

# Constraints
# Workplace safety impact constraints
m.addConstr(10 * x0 + 3 * x1 + 8 * x2 + 2 * x3 + 4 * x4 <= 180, name="workplace_safety_impact")
m.addConstr(10 * x0 + 2 * x1 + 6 * x2 + 9 * x3 + 4 * x4 <= 82, name="storage_space")
m.addConstr(9 * x0 + 9 * x1 + 1 * x2 + 5 * x3 + 4 * x4 <= 168, name="employee_satisfaction_impact")
m.addConstr(11 * x0 + 1 * x1 + 7 * x2 + 4 * x3 + 11 * x4 <= 239, name="usefulness_rating")

# Additional constraints
m.addConstr(10 * x0 + 2 * x3 + 4 * x4 >= 19, name="workplace_safety_impact_min")
m.addConstr(2 * x1 + 6 * x2 + 9 * x3 >= 11, name="storage_space_min_1")
m.addConstr(10 * x0 + 6 * x2 + 9 * x3 >= 11, name="storage_space_min_2")
m.addConstr(2 * x1 + 9 * x3 + 4 * x4 >= 11, name="storage_space_min_3")
m.addConstr(2 * x1 + 6 * x2 + 9 * x3 >= 12, name="storage_space_min_4")
m.addConstr(10 * x0 + 6 * x2 + 9 * x3 >= 12, name="storage_space_min_5")
m.addConstr(2 * x1 + 9 * x3 + 4 * x4 >= 12, name="storage_space_min_6")
# ... (rest of the constraints)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"3D printers: {x0.varValue}")
    print(f"Staplers: {x1.varValue}")
    print(f"Yellow highlighters: {x2.varValue}")
    print(f"Red highlighters: {x3.varValue}")
    print(f"Blue pens: {x4.varValue}")
    print(f"Objective: {m.objVal}")
else:
    print("No optimal solution found.")
