
import gurobipy as gp

# Create a new model
m = gp.Model("minimize_labor_cost")

# Create variables
george_hours = m.addVar(lb=0, name="george_hours")
dale_hours = m.addVar(lb=0, name="dale_hours")

# Set objective function
m.setObjective(7 * george_hours + 7 * dale_hours, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(5 * george_hours + 3 * dale_hours >= 14, "paperwork_min")
m.addConstr(15 * george_hours + 9 * dale_hours >= 14, "computer_min")
m.addConstr(george_hours - 7 * dale_hours >= 0, "george_dale_relation")
m.addConstr(5 * george_hours + 3 * dale_hours <= 45, "paperwork_max")
m.addConstr(15 * george_hours + 9 * dale_hours <= 50, "computer_max")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found: George = {george_hours.x}, Dale = {dale_hours.x}")
    print(f"Objective value: {m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

